#!/bin/bash
admin_dir='/home/pi/ADMIN'
cafca_dir='/home/pi/CAFCA'
cafca_log="$cafca_dir/log/CAFCA.log"
cafca_settings="$cafca_dir/data/.settings"
cafca_action=$(grep -w -m1 'action' "$cafca_settings" | cut -d= -f2 | tr '[:lower:]' '[:upper:]')


exec > >(sudo tee -a "$cafca_log" 2>&1)

sudo python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/systems_check.py

setsid sudo bash "$cafca_dir/CAFCA.sh" "$cafca_action" RUNCMD &> /dev/null &
cafca_pid=$!
cafca_pgid=$(ps opgid= "$cafca_pid")


sudo sed -i '/UI/d' "$admin_dir/.sys/.states" && sleep 1
echo "VAR UI=RA" | sudo tee -a "$admin_dir/.sys/.states" &>/dev/null

sudo sed -i '/GAME_LOADED/d' "$cafca_dir/data/.states" && sleep 1
echo "BOOL GAME_LOADED=1" | sudo tee -a "$cafca_dir/data/.states" &>/dev/null

sudo sed -i '/SID/d' "$cafca_dir/data/.states" && sleep 1
echo "SID=$cafca_pgid" | sed -e 's/ //g' | sudo tee -a "$cafca_dir/data/.states" &>/dev/null

