#!/bin/bash

#---------------------------------------------------
# GLOBAL VARS

debug=1

action='DUMP'
mode='RUNCMD'

system='mame-libretro'
game=''
coin_addr=''
credits_str=''

retro_running=0
game_ready=0
game_listed=0
identified=0

credits=0
coins_count=0
start_count=0

coin_key="KEY_C"
start_key="KEY_S"

loaded_str='hiscore memory file'

declare -A data=()
declare -a regions=()

#___________________________________________________
#
# MAIN

Main() {
  debug "Main():\n"
  debug "MODE:\t$mode\n\tACTION:\t$action\n\n"

  if [[ "$action" == DUMP ]]; then
    if [[ "$mode" == RUNCMD ]]; then
      cafca_dump
    elif [[ "$mode" == LAUNCH ]]; then
      # launch retroarch
      sleep 1
    fi

  elif [[ "$action" == SCAN ]]; then
    if [[ "$mode" == LAUNCH ]]; then
      if [ "${#args[@]}" -gt 2 ]; then
        game=$(echo "$4" | tr '[:upper:]' '[:lower:]')
      elif [ "${#args[@]}" -gt 3 ]; then
        system=$(echo "$3" | tr '[:upper:]' '[:lower:]')
        game=$(echo "$4" | tr '[:upper:]' '[:lower:]')
      fi
      cafca_scan
    fi
  fi
}

#___________________________________________________
#
# FUNCTIONS

cafca_dump() {
  retro_running=1

  serialSend "GAME_LOADED 1"

  if [[ "$mode" == RUNCMD ]]; then
    system=$(awk 'NR==1' $rc_info);debug "SYSTEM: $system\n"
    game=$(awk -F'/' 'NR==3 {print $NF}' $rc_info | cut -d. -f1);debug "GAME: $game\n"
  fi

  game_name=$(echo "$game" | tr '[:lower:]' '[:upper:]')

  serialSend "GAME_NAME $game_name"
  serialSend "GAME_SYSTEM $system"
  #vfd_format "$game_name"

  #------------------------------------------------

  game_table="$data_dir/$system/game_table"
  game_listed=$(cat "$game_table" | grep -wc "$game")
  debug "GAME LISTED: $game_listed"

  #------------------------------------------------

  game_ready=0

  while (( ! $game_ready )); do
    game_ready=$(grep -c -m1 "$loaded_str" $ra_log)
  done

  #serialSend "VFD 7 READY!"

  #------------------------------------------------

  watch_credits "$game_listed"

  if [[ $game_listed -gt 0 ]]; then
    get_gamedata
    getAddr
  fi

  #------------------------------------------------

  while (( $retro_running )); do
    retro_running=$(ps -ef | grep -v grep | grep -c -m1 retroarch)
    coins_count=$(cat "$file_coins_count")
    start_count=$(cat "$file_start_count")
    serialSend "LCD 0 C: $coins_count, S: $start_count"
    sleep 1
    serialSend "LCD 1 CREDITS: $(( coins_count - start_count ))"
    sleep 1
  done

}

getAddr() {
  local scan_args='option region_scan_level 3;reset;lregions;exit'

  debug "\n\ngetAddr():\n"

  sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -P -A1000 '\[ 0\]' |& sed s'/[][,]//g' | sudo tee "$file_regionlist" &>/dev/null && sudo sed -i '/> exit/d' "$file_regionlist"

  while (( ! $credits )); do
    calc_credits
  done

  sleep 1

  [[ "${data[NAME]}" == code ]] && get_regions 'code'

  serialSend "VFD 7       DONE!"

}

get_regions() {
  local args="${@}"
  local region_list=$(cat "$file_regionlist")

  debug "get_regions()\n\targs: ${args[@]} (${#})\n\n"

  if [[ "${1}" == code ]]; then
    if [[ ${#} -lt 2 ]]; then
      reg_num=$(( ${data[NUM]} + 1 ))
      reg_start=$reg_num
      reg_end=$(( reg_start + 1 ))
    fi
  fi

  for (( i=$reg_start; i<$reg_end; i++)); do
    line=$(awk -v ln="$reg_num" 'NR==ln' "$file_regionlist" | awk '{$1=$1; print}')
    name=$(echo "$line" | awk '{print $5}')
    [[ $name == ${data[NAME]} ]] && regions+=("0x$(echo "$line" | awk '{print $2}')")
  done

  dump_addr
}

dump_addr() {
  debug "\n\n\$regions[]:\n\n"
  debug "\n\nlength:${#regions[@]}\n\n"

  for (( i=0; i<${#regions[@]}; i++)); do
    BASE="${regions[$i]}"
    OFFS="${data[OFFS]}"
    ADDR="";printf -v ADDR "0x%X\n" $(( BASE + OFFS)) &>/dev/null; ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
    VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

    calc_credits 1

    debug "\${regions[$i]}:"
    debug "\n\n\tBASE: $BASE\n\tOFFS: $OFFS\n\tADDR: $ADDR\n\tVAL: $VAL\n\n"
    debug "credits_str: $credits_str"

    if [[ "$VAL" == "$credits_str" ]]; then
      debug "VAL == credits_str"
      LASTVAL="$credits_str"

      printf -v credits_str '%02d' "$(( credits + 1 ))" &>/dev/null && debug "credits_str: $credits_str"
      sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $credits_str;exit" &>/dev/null
      sleep 1

      VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

      calc_credits 1

      debug "NEW: $VAL"

      if [[ ! $VAL == $LASTVAL ]]; then
        identified=1
        debug "IDENTIFIED!"
      fi

      sleep 1

      sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $credits_str;exit" &>/dev/null
    fi

    #(( $identified )) && serialSend "VFD 7 IDENTIFIED!"

      #if [[ $value == $credit_string ]]; then
      #  LASTVAL=$credit_string
      #  credits=$(( credits + 1 ))
      #  printf -v credit_string '%02d' "$credits" &>/dev/null
      #
      #  sudo scanmem -p `pidof retroarch` -c"write i16 $addr $credit_string;exit" &>/dev/null
      #  sleep 1
      #
      #  VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
      #  debug "  NEW: $VAL, LAST: $LASTVAL"
      #
      #  if [[ ! $VAL == $LASTVAL ]]; then
      #    matched=1
      #    coin_addr=$addr
      #
      #    sudo scanmem -p `pidof retroarch` -c"write i16 $addr $LASTVAL;exit" &>/dev/null
      #
      #    debug "\n\nMATCH IDENTIFIED: $num"
      #    debug "ADDR: $coin_addr"
      #    serialSend "VFD 7 MATCH FOUND!"
      #    break
      #  else
      #    sudo scanmem -p `pidof retroarch` -c"write i16 $addr $LASTVAL;exit" &>/dev/null
      #  fi
      #fi
      #[[ $matched -gt 0 ]] && break
  done
}

get_gamedata() {
  local table_data=$(cat "$game_table" | grep -w "$game" | awk '{$1=$1;print}')

  data[GAME]=$(echo "$table_data" | awk '{print $1}')
  data[OFFS]=$(echo "$table_data" | awk '{print $2}')
  data[NUM]=$(echo "$table_data" | awk '{print $3}')
  data[NAME]=$(echo "$table_data" | awk '{print $4}')
  data[TYPE]=$(echo "$table_data" | awk -F'\[' '{print substr($2,0,length($2))}')

  debug "\n\nget_gamedata():\n"
  debug "DATA:\n"

  for i in "${!data[@]}"; do
    debug "$i:\t\t${data[$i]}"
  done
}

calc_credits() {
  coins_count=$(cat "$file_coins_count")
  start_count=$(cat "$file_start_count")
  credits=$(( coins_count - start_count ))
  [[ $# > 0 ]] && printf -v credits_str '%02d' "$credits" &>/dev/null
}


watch_credits() {
  read_inputs &
}

read_inputs() {
  local coins_cnt=0
  local start_cnt=0

  local limit_start=20
  local t_start=$limit_start
  local last_start=$(date +%s)

  while read -r line; do
    pressed=$(echo "$line" | grep -E "$coin_key|$start_key" | \
      awk -v C="$coin_key" -v S="$start_key" '{
        if ($2 == C) print "COIN"
        if ($2 == S) print "START"
      }')

    coins_cnt=$(cat "$file_coins_count")
    start_cnt=$(cat "$file_start_count")

    if [[ $pressed == COIN ]]; then
      echo "$(( coins_cnt + 1 ))" | sudo tee $file_coins_count &>/dev/null
    elif [[ $pressed == START ]]; then
      if [[ $coins_cnt -gt 0 ]]; then
        if [[ $start_cnt -gt 0 ]]; then
          t_start=$(( `date +%s` - $last_start ))
          if [[ $t_start -ge $limit_start ]]; then
            echo "$(( start_cnt + 1 ))" | sudo tee $file_start_count &>/dev/null
            t_start=0
            last_start=$(date +%s)
          fi
        else
          echo "$(( start_cnt + 1 ))" | sudo tee $file_start_count &>/dev/null
          t_start=0
          last_start=$(date +%s)
        fi
      fi
    fi
  done< <(thd --dump "$teensy_kbd" 2>&1 |& grep --line-buffered -E "$coin_key|$start_key" | awk -W interactive '{$1=$1;print}' | grep --line-buffered -Ew "EV_KEY $coin_key 1|EV_KEY $start_key 1" 2>&1)
}

wipe() {
  file="$@"
  [[ ! -f "$file" ]] && sudo touch "$file" &>/dev/null \
  || echo -e "\n" | sudo tee "$file" &>/dev/null
  sudo chmod 775 "$file" &>/dev/null
  #debug "wipe(): $file\n"
}

vfd_format() {
  local title=$1
  local length=$(( $(echo "$title" | wc -m) - 1 ))
  local spacing=$(( (16 - $length) / 2 ))
  local str=""

  if [[ $spacing -lt 16 ]]; then
    for (( i=0;i<$spacing;i++ )); do
      str+=" "
    done
    str+="$title"
    mode=4
  else
    str="$title"
    mode=2
  fi

  debug "VFD - title : $title"
  debug "VFD - length: $length"
  debug "VFD - spacing: $spacing"
  debug "VFD - string: $str"

  serialSend "VFD $mode $str"
}

serialSend() {
 [ -c /dev/ttyACM0 ] && printf "${@}" > /tmp/pyserial.fifo #&>/dev/null
  sleep 1
}

cafca_scan() {
  sleep 1
}

press_key() {
  printf $@ > /tmp/vkbdd.fifo
}

debug() {
  (( $debug )) && echo -e "[DEBUG] $@"
}

cleanup() {
  debug "Cleaning up..."
  serialSend "GAME_STOPPED 1"
  (( $retro_running )) && printf '\033' >/tmp/vkbdd.fifo #sudo pkill retroarch
}

#_____________________________________________________
#
# SETUP
#
#-----------------------------------------------------

#CONSTS:

SCRIPT=$(readlink -f $0)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
DIR=$(cd $(dirname $SCRIPT) && pwd)

args=("$@")
root_user=

log_dir="$DIR/log"
log_file="$log_dir/CAFCA.log"
rc_log='/dev/shm/runcommand.log'
rc_info='/dev/shm/runcommand.info'
ra_log="$log_dir/retroarch/retroarch.log"

teensy_kbd='/dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'

data_dir="$DIR/data"
game_table="$data_dir/$system/game_table"

file_regionlist="$data_dir/tmp/regionlist"
file_coins_count="$data_dir/tmp/cafca_coins_cnt"
file_start_count="$data_dir/tmp/cafca_start_cnt"

bypass=$(grep bypass "$data_dir/.settings" | cut -d= -f2)

#---------------------------------------------------

(( ! $(id -u) )) && root_user=1 || root_user=0

wipe "$log_file"
wipe "$ra_log"

ra_log_owner=$(ls -l "$log_dir/retroarch" | grep "$(echo $ra_log | cut -d/ -f7)" | awk '{print $3" "$4}')

if [[ $ra_log_owner != "pi pi" ]]; then
  debug "setting log rights to pi:pi"
  sudo chown pi:pi "$ra_log"
fi

exec > >(sudo tee $log_file 2>&1)

debug "\n\nC A F C A\n\n`date '+%d/%m-%Y %T'`\n\nHOMEDIR:\t$HOMEDIR\nDIR:\t\t$DIR\nSCRIPT:\t\t$SCRIPT\nROOT USER:\t$root_user\n"

if [ "${#args[@]}" -gt 0 ]; then
  action=$(echo "$1" | tr '[:lower:]' '[:upper:]')
  [ "${#args[@]}" -gt 1 ] && mode=$(echo "$2" | tr '[:lower:]' '[:upper:]')
  debug "ARGS: \x27${args[@]}\x27 (${#args[@]})\n\n"
else
  debug "NO ARGS..\n"
fi

(( $debug )) && echo -e "_____________________________________________\n"

trap cleanup EXIT

wipe "$file_regionlist"
wipe "$file_coins_count" && echo 0 | sudo tee "$file_coins_count" &>/dev/null
wipe "$file_start_count" && echo 0 | sudo tee "$file_start_count" &>/dev/null

[[ $bypass -ne 1 ]] && Main

# if !Main:
#debug "CAFCA BYPASSED.."

exit 0





#____________________________________________________
















###################################################



































cafca_dump2() {
  serialSend "GAME_LOADED 1"
  retro_running=1

  if [[ "$mode" == RUNCMD ]]; then
    system=$(awk 'NR==1' $rc_info);echo -e "SYSTEM: $system\n"
    game=$(awk -F'/' 'NR==3 {print $NF}' $rc_info | cut -d. -f1);echo -e "GAME: $game\n"
  fi

  debug "GAME: $game"
  debug "SYSTEM: $system"
  serialSend "GAME_NAME $game"
  serialSend "GAME_SYSTEM $system"

  game_table="$cafca_dir/data/$system/offsets/$game"
  debug "GAME TABLE: $game_table"
  sed -i '/^$/d' "$game_table" # remove empty rows

  [ -f "$game_table" ] && game_listed=1

  if [[ "$game_listed" -gt 0 ]]; then
    debug "GAME_LISTED: 1"
    serialSend "VFD 1 GAME LISTED" & #REM

    check_table

    [[ ! $(grep -c -m1 "$loaded_str") ]] && \
    tail -f "$ra_log" | grep -c -m1 -q --line-buffered "hiscore memory file" &>/dev/null && debug "READY!\n"

    debug "GAME LOADED!"

    serialSend "GAME_ADDR 1"
    #serialSend "COIN_READY 1" # ADD

    wait_coin

    serialSend "CREDITS $credits"

    debug "COIN INSERTED!"
    debug "CREDITS: $credits"

    [[ "$regions_found" -gt 0 ]] && get_regions "PRE" "$reg_pref" || get_regions "SCAN" "misc"

    serialSend "VFD 0 DONE!"
    serialSend "COIN_READY 1"

  else
    debug "GAME_LISTED: 0"
    serialSend "VFD 1 GAME NOT LISTED"
    serialSend "GAME_ADDR 0"
    serialSend "COIN_READY 1"
  fi

  while (( $retro_running )); do
     retro_running=$(ps -ef | grep -v grep | grep -c -m1 retroarch)

     if [[ $identified -gt 0 ]]; then
       coin_val=$(sudo scanmem -p `pidof retroarch` -c"dump $coin_addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
       debug "ADDR: $coin_addr, VAL: $coin_val"
       serialSend "CREDITS $coin_val"
       sleep 1
       serialSend "LCD 0 CREDITS:"
       serialSend "LCD 1 $coin_val"
     fi

     sleep 3
  done

  serialSend "GAME_STOPPED 1"

}


# PATHS
log_dir="$cafca_dir/log"
log_file="$log_dir/CAFCA.log"
scan_log="$log_dir/scanlog.log"

ra_log="$log_dir/retroarch/retroarch.log"
crt_log='/dev/shm/CRT_Launcher.log'
rc_log='/dev/shm/runcommand.log'
rc_info='/dev/shm/runcommand.info'

retroarch="/opt/retropie/emulators/retroarch/bin/retroarch"
mame_core="/opt/retropie/libretrocores/lr-mame2003/mame2003_libretro.so"

game_dir="/home/pi/RetroPie/roms/$system"
config="$cafca_dir/cfg/$system.cfg"
data_dir="$cafca_dir/data/$system/offsets"

teensy_kbd='usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'
#_____________________________________________________


# VARIABLES

args=("$@")

action='DUMP'
mode='RUNCMD'

debug=1
retro_running=0
game_listed=0
regions_found=0
identified=0

loaded_str="hiscore memory file"
system='mame-libretro'
game=''
reg_pref="misc"
game_table=
coin_addr=
credits=0

coin_key="KEY_C"
start_key="KEY_S"
key_exit=0
key_coin=0
key_start=0

bypass=$(grep bypass $cafca_dir/data/.settings | cut -d= -f2)

declare -A array=()
declare -a names=()
declare -a matchlist=()
declare -a thisArr=()

declare -a regionlist=()

#_____________________________________________________
#
# SETUP

sudo touch $log_file && sleep 1
exec > >(sudo tee $log_file 2>&1)

echo -e "\nC A F C A\n"; echo -e `date "+%d/%m-%Y %T"` "\n\n"

if [ "${#args[@]}" -gt 0 ]; then
  echo -e "ARGS: \x27${args[@]}\x27 (n=${#args[@]})\n\n"
  action=$(echo "$1" | tr '[:lower:]' '[:upper:]')
  [ "${#args[@]}" -gt 1 ] && mode=$(echo "$2" | tr '[:lower:]' '[:upper:]')

else
  echo -e "NO ARGS\n\n" #args=("$@") #|| args=('none')
fi

[ ! -f "$ra_log" ] && sudo touch "$ra_log"
sleep 1

log_own=$(ls -l "$log_dir/retroarch" | grep "$ra_logname" | awk '{print $3" "$4}')

if [[ $log_own != "pi pi" ]]; then
  echo "setting log right to pi:pi"
  sudo chown pi:pi "$log_dir/retroarch/$ra_logname"
fi

#-----------------------------------------------------

Main() {
  echo -e "MODE:\t$mode\nACTION:\t$action\n\n"

if [[ "$action" == DUMP ]]; then
  [ "${#args[@]}" -lt 2 ] && mode="DEFAULT"
  if [[ "$mode" == RUNCMD ]]; then
    cafca_dump
  elif [[ "$mode" == LAUNCH ]]; then
    # launch retroarch
    pat='var'
  fi

elif [[ "$action" == SCAN ]]; then
  if [[ "$mode" == LAUNCH ]]; then
    if [ "${#args[@]}" -gt 2 ]; then
       system=$(echo "$3" | tr '[:upper:]' '[:lower:]')
    elif [ "${#args[@]}" -gt 3 ]; then
      system=$(echo "$3" | tr '[:upper:]' '[:lower:]')
      game=$(echo "$4" | tr '[:upper:]' '[:lower:]')
    fi
    cafca_scan
  fi
fi

}

#-----------------------------------------------------


check_table() {
  while read -r line; do
    name=$(echo "$line" | awk '{print $3}')
    names_str+="$name\n"
    [[ "$name" == "$reg_pref" ]] && regions_found=1
  done< <(cat "$game_table")
  names=($(echo -e "$names_str" | sort | uniq))

  if [[ "${#names[@]}" -lt 2 ]]; then
    reg_pref="${names[0]}"
    debug "reg_pref: $reg_pref"
    regions_found=1
  fi

  debug " "
  debug "Reg. names: ${names[@]}"
  debug " "

  for (( i=0; i<${#names[@]}; i++ )); do
    arr_name="${names[$i]}"
    eval "sub_arr=(\"\${$arr_name[@]}\")"

    while read -r line; do
      name=$(echo "$line" | awk '{print $3}')
      [[ "$name" == "$arr_name" ]] && sub_arr+=("$line;")
    done< <(cat "$game_table")

    nameUp=$(echo "$arr_name" | tr [a-z] [A-Z])
    array["$nameUp"]="${sub_arr[@]}"
  done
  [[ $regions_found -gt 0 ]] && readArray "$reg_pref"
}

get_regions() {
  local mode="${1}"
  local data_name="${2}"
  local data=$(cat "$game_table")
  local misc_regs=()

  debug " "
  debug "get_regions():"
  debug " "

  printf -v credit_string '%02d' "$credits" &>/dev/null

  entries=${#thisArr[@]}

  if [[ $reg_pref == code ]]; then
    for (( r=0; r<$entries;r++ )); do
      num=$(echo "${thisArr[$r]}" | awk '{print $2}')
      offset=$(echo "${thisArr[$r]}" | awk '{print $1}')
      nom=$(echo "${thisArr[$r]}" | awk '{print $3}')
      [[ ! $nom == code ]] && continue

      region_list=$(sudo scanmem -p `pidof retroarch` -c"option region_scan_level 3;reset;dregions !$num;lregions;exit" 2>&1 |& awk -W interactive 'NR>19' | sed -e "s/\[//g" -e "s/\]//g")
      base=$(echo "$region_list" | awk 'NR==1 {print "0x"substr($2,0,length($2))}')
      printf -v addr "0x%X\n" $(( base + offset)) &>/dev/null
      addr=$(echo "$addr" | tr '[A-Z]' '[a-z]')
      value=$(sudo scanmem -p `pidof retroarch` -c"dump $addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
      debug "N: $num: B:$base O:$offset A:$addr V:$value"

      if [[ $value == $credit_string ]]; then
        LASTVAL=$credit_string
        credits=$(( credits + 1 ))
        printf -v credit_string '%02d' "$credits" &>/dev/null

        sudo scanmem -p `pidof retroarch` -c"write i16 $addr $credit_string;exit" &>/dev/null
        sleep 1

        VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
        debug "  NEW: $VAL, LAST: $LASTVAL"

        if [[ ! $VAL == $LASTVAL ]]; then
          matched=1
          coin_addr=$addr

          sudo scanmem -p `pidof retroarch` -c"write i16 $addr $LASTVAL;exit" &>/dev/null

          debug "\n\nMATCH IDENTIFIED: $num"
          debug "ADDR: $coin_addr"
          serialSend "VFD 7 MATCH FOUND!"
          break
        else
          sudo scanmem -p `pidof retroarch` -c"write i16 $addr $LASTVAL;exit" &>/dev/null
        fi
      fi
      [[ $matched -gt 0 ]] && break
    done
  else
    region_list=$(sudo scanmem -p `pidof retroarch` -c"option region_scan_level 3;reset;dregions !$num;lregions;exit" 2>&1 |& awk -W interactive 'NR>19' | sed -e "s/\[//g" -e "s/\]//g")
    #region_list=$(sudo scanmem -p `pidof retroarch` -c"lregions;exit" 2>&1 |& awk -W interactive 'NR>14' | sed -e "s/\[//g" -e "s/\]//g")
    printf -v credit_string '%02d' "$credits" &>/dev/null

    if [[ "$mode" == PRE ]]; then # table regions first
      debug "mode == PRE"
      for (( r=0; r<$entries;r++ )); do
        num=$(echo "${thisArr[$r]}" | awk '{print $2}')
        offset=$(echo "${thisArr[$r]}" | awk '{print $1}')
        base=$(echo "$region_list" | awk -v row=$((num+1)) 'NR==row {print "0x"substr($2,0,length($2))}')
        printf -v addr "0x%X\n" $(( base + offset)) &>/dev/null
        addr=$(echo "$addr" | tr '[A-Z]' '[a-z]')
        value=$(sudo scanmem -p `pidof retroarch` -c"dump $addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
        debug "N: $num: B:$base O:$offset A: $addr V: $value"
        [[ $value == $credit_string ]] && matched=1
      done
    fi

    [[ $matched -gt 0 ]] && return

    while read -r line; do
      reg_name=$(echo "$line" | awk '{print substr($5, 0, length($5))}')
      reg_offs=$(echo "$line" | awk '{print $1" 0x"substr($2,0,length($2))}')
      [[ "$reg_name" == "$data_name" ]] && misc_regs+=("$reg_offs")
    done< <(echo "$region_list")

    for (( r=0; r<$entries;r++ )); do
      OFFSET=$(echo "${thisArr[$r]}" | awk -v row="$(( r+1 ))" 'NR==row {print $1}')
      OFFS_NUM=$(echo "${thisArr[$r]}" | awk -v row="$(( r+1 ))" 'NR==row {print $2}')

      debug "\n\nREG $OFFS_NUM, OFFS: $OFFSET"
      debug " "
      printf -v credit_string '%02d' "$credits" &>/dev/null

      for reg in "${misc_regs[@]}"; do
        REGNUM=$(echo "$reg" | awk '{print $1}')
        BASE=$(echo "$reg" | awk '{print $2}')
        printf -v ADDR "0x%X\n" $(( BASE + OFFSET)); ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
        VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
        debug "  ENTRY: $REGNUM, ADDR: $ADDR, VAL: $VAL"

        if [[ $VAL == $credit_string ]]; then
          debug "  M A T C H !"

          LASTVAL=$credit_string
          credits=$(( credits + 1 ))
          printf -v credit_string '%02d' "$credits" &>/dev/null

          sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $credit_string;exit" &>/dev/null
          sleep 1
          VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

          debug "  NEW: $VAL, LAST: $LASTVAL"

          if [[ ! $VAL == $LASTVAL ]]; then
            matched=1
            coin_addr=$ADDR

            sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $LASTVAL;exit" &>/dev/null

            debug "\n\nMATCH IDENTIFIED: $REGNUM"
            debug "ADDR: $coin_addr"
            serialSend "VFD 7 MATCH FOUND!"
            break
          else
            sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $LASTVAL;exit" &>/dev/null
          fi
        fi
      done
      [[ $matched -gt 0 ]] && break
    done
  fi

  if [[ $matched -gt 0 ]]; then
    identified=$matched
    debug "identified!"
    serialSend "GAME_ADDR 1"
  else
    debug "\n\nno match identified.."
    serialSend "GAME_ADDR 0"
  fi
}

readArray() {
  local mode="${1}"
  local name=$(echo "$mode" | tr [a-z] [A-Z])

  debug "readArray():"
  debug "mode: $name"
  debug " "

  if [[ ! $mode == ALL ]]; then
    array_line=$(echo "${array[$name]}" | awk 'BEGIN{RS=";"}{$1=$1}1')
    lines=$(echo "$array_line" | wc -l)

    debug "\${array[$name]}=("

    for (( i=1; i<=$lines; i++ )); do
      line=$(echo "$array_line" | awk -v ln="$i" 'NR==ln')
      thisArr+=("$line")
    done

    thisArr_len="${#thisArr[@]}"
    for (( i=0; i<thisArr_len; i++ )); do
      debug "  \x27${thisArr[$i]}\x27"
    done
    debug ")"
    debug " "

  elif [[ $mode == ALL ]]; then
    for key in "${!array[@]}"; do
      array_line=$(echo "${array[$name]}" | awk 'BEGIN{RS=";"}{$1=$1}1')
      lines=$(echo "$array_line" | wc -l)

      debug "\${array[$name]}=("

      for (( i=1; i<=$lines; i++ )); do
        line=$(echo "$array_line" | awk -v ln="$i" 'NR==ln')
        thisArr+=("$line")
      done

      thisArr_len="${#thisArr[@]}"
      for (( i=0; i<thisArr_len; i++ )); do
        debug "  \x27${thisArr[$i]}\x27"
      done
      debug ")"
      debug " "
    done
  fi
}

read_coin() {
  while (( $retro_running )); do
    thd --dump "/dev/input/by-id/$teensy_kbd" | grep -q "$coin_key" && credits=$(( credits + 1 )) #printf -v credits '%02d' 1 &>/dev/null
    serialSend "VFD 6 COIN INSERTED!"
  done
}

wait_coin() {
  serialSend "LCD 0 READY!" &
  thd --dump "/dev/input/by-id/$teensy_kbd" | grep -q "$coin_key" && credits=1 #printf -v credits '%02d' 1 &>/dev/null
  serialSend "VFD 6 COIN INSERTED!"
  #printf -v credits '%02d' 1 &>/dev/null
}

#press_key() {
#  key="{$@}"
#  printf "$key" > /tmp/vkbdd.fifo
#}

#________________________________________

check_regions() {
  for r in {0..1}; do
    reg="${regions[$r]}"
    reg_base=$(sudo scanmem -p `pidof retroarch` -c"option region_scan_level 3;reset;dregions !$reg;lregions;exit" 2>&1 | awk 'NR==20 {print "0x"substr($2, 0, length($2))}')
    echo -e "\nREGION $reg:\nBASE: $reg_base\n"
    for i in {0..1};do
      reg_offset="${offsets[$i]}"
      printf -v ADDR "0x%X\n" $(( reg_base + reg_offset)) &>/dev/null;ADDR=$(echo "$ADDR" | tr '[:upper:]' '[:lower:]')
      val=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
      echo -e "\nOFFS: $reg_offset\n$ADDR: $val"
      if [[ $val == $credits ]]; then
      #if [[ $val == 1 ]]; then
         coin_addr=$ADDR
         echo -e "COIN ADDR: $coin_addr"
         break
      fi
    done
    echo -e "________________________________________________"
  done
}

get_region_data() {

  local region_list=$(sudo scanmem -p `pidof retroarch` -c"lregions;exit" 2>&1 |& awk -W interactive 'NR>18' | sed -e "s/\[//g" -e "s/\]//g")
  local misc_regs=()
#  local data=

#  [ -f $data_table ] && \
#    data=$(cat $data_table | awk 'NR==2');
    data_offset=$(echo "$data" | awk '{print $1}') #;
    data_reg=$(echo "$data" | awk '{print $2}') #;
    data_name=$(echo "$data" | awk '{print $3}') #;
    data_pos=$(echo "$data" | awk '{print $4}') #;

  echo -e "data: $data\noffset: $data_offset\nregion: $data_reg\npos: $data_pos\nname: $data_name\n"

  REG_RANGE_LO=$(( $data_reg - 5 ))
  REG_RANGE_HI=$(( $data_reg + 5 ))

  while read -r line; do
   reg_name=$(echo "$line" | awk '{print substr($5, 0, length($5))}')
   if [[ "$reg_name" == "$data_name" ]]; then
     reg_offs=$(echo "$line" | awk '{print $1" 0x"substr($2,0,length($2))}')
     misc_regs+=("$reg_offs")
   fi
  done< <(echo "$region_list")

  for reg in "${misc_regs[@]}"; do
    REGNUM=$(echo "$reg" | awk '{print $1}')
    BASE=$(echo "$reg" | awk '{print $2}'); OFFSET="$data_offset"

    #if [[ "$REGNUM" == "$data_reg" ]]; then
    #if [ "$REGNUM" -gt "$REG_RANGE_LO" ] && [ "$REGNUM" -le "$REG_RANGE_HI" ]; then
      printf -v ADDR "0x%X\n" $(( BASE + OFFSET)); ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
      dump_line=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 |& awk -W interactive 'NR==15') #| sed -e "s/\[//g" -e "s/\]//g")
      credit_var=$(echo "$dump_line" | awk -F' ' '{print $2}')
      credit_dec=$( printf "%d" "0x$credit_var")
      #echo "$credit_var"
      #case $credit_var in
      #  ''|*[!0-9]*) ;;
      #  *) echo "$credits_var" ;;
      #esac
      echo -e "REG $REGNUM:\nBASE: $BASE;\nADDR: $ADDR\nVALUE: $credit_var\n"
      if (( $credit_dec == $credits)); then
         echo -e "\nMATCH!"
         sleep 2
      fi
      sleep 0.5
    #fi
  done

#exit
}

check_entry() {
  game_table="$cafca_dir/data/$system/offsets/$game"
  debug "TABLE: $game_table"
  [ ! -f "$game_table" ] && serialSend "VFD 0 NO ADDR" \
  || serialSend "VFD 0 ADDR!"
  #exit 1
  #|| (while :; do sleep 1; done)
}

press_key() {
  key="$@"
  printf "$key" > /tmp/vkbdd.fifo
}

debug() {
   if (( "$debug"  )); then
      msg="$@"
      #msg=$1
      echo -e "[DEBUG] $msg"
   fi
}

serialSend() {
 [ -c /dev/ttyACM0 ] &&  printf "${@}" > /tmp/pyserial.fifo #&>/dev/null
  sleep 3
}


#press_key() {
#  key="{$@}"
#  printf "$key" > /tmp/vkbdd.fifo
#}


cleanup() {
  debug "Cleaning up..."
  (( $retroarch_running )) && printf '\033' >/tmp/vkbdd.fifo #sudo pkill retroarch
  sleep 2
  sudo pkill tail
  #sudo cp "$log_file" "$cafca_dir/.BAK/retroarch.log.bak"
  #echo -e "\n" | sudo tee "$log_file" &>/dev/null
  #sudo rm "$cafca_dir"/*.lpl &>/dev/null

}

trap cleanup EXIT

(( ! $bypass )) && Main

exit

#________________________________________________________________________


#Main() {
  #wait_for_coin
  #sleep 1

  #echo "credits: $credits"
  #check_regions

  #[ "${#coin_addr}" -lt 1 ] && return

  #val=$(sudo scanmem -p `pidof retroarch` -c"dump $coin_addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  #echo -e "Credits: $val"
  #printf "CREDITS $val" > /tmp/pyserial.fifo


  #while (( $retro_running )); do
  #  retro_running=$(ps -ef | grep -v grep | grep -c -m1 retroarch)
  #  wait_for_keys
  #  #wait_for_coin
  #  sleep 1
  #  val=$(sudo scanmem -p `pidof retroarch` -c"dump $coin_addr 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  #  echo -e "Credits: $val"
  #  printf "CREDITS $val" > /tmp/pyserial.fifo
  #done

  #serialSend "GAME_STOPPED 1"

#}
