#!/bin/bash

#---------------------------------------------------
# GLOBAL VARS

debug=1
testing=1

action='DUMP'
mode='RUNCMD'

system='mame-libretro'
game=''
coin_addr=''
credits_str=''

retro_running=0
game_ready=0
game_listed=0
identified=0

credits=0
coins_count=0
start_count=0

coin_key="KEY_C"
start_key="KEY_S"

loaded_str='hiscore memory file'

declare -A data=()
declare -a regions=()

#___________________________________________________
#
# MAIN

Main() {
  debug "Main():\n"
  debug "MODE:\t$mode\n\tACTION:\t$action\n\n"

  if [[ "$action" == DUMP ]]; then
    if [[ "$mode" == RUNCMD ]]; then
      cafca_dump
    elif [[ "$mode" == LAUNCH ]]; then
      # launch retroarch
      sleep 1
    fi
  elif [[ "$action" == SCAN ]]; then
    if [[ "$mode" == LAUNCH ]]; then
      if [ "${#args[@]}" -gt 2 ]; then
        game=$(echo "$4" | tr '[:upper:]' '[:lower:]')
      elif [ "${#args[@]}" -gt 3 ]; then
        system=$(echo "$3" | tr '[:upper:]' '[:lower:]')
        game=$(echo "$4" | tr '[:upper:]' '[:lower:]')
      fi
      cafca_scan
    fi
  fi
}

#___________________________________________________
#
# FUNCTIONS

cafca_dump() {
  retro_running=1

  serialSend "GAME_LOADED 1"

  if [[ "$mode" == RUNCMD ]]; then
    system=$(awk 'NR==1' $rc_info);debug "SYSTEM: $system\n"
    game=$(awk -F'/' 'NR==3 {print $NF}' $rc_info | cut -d. -f1);debug "GAME: $game\n"
  fi

  game_name=$(echo "$game" | tr '[:lower:]' '[:upper:]')

  serialSend "GAME_NAME $game_name"
  serialSend "GAME_SYSTEM $system"
  #vfd_format "$game_name"

  #------------------------------------------------

  game_table="$data_dir/$system/game_table"
  game_listed=$(cat "$game_table" | grep -wc "$game")
  debug "GAME LISTED: $game_listed"

  #------------------------------------------------

  (( $testing )) && game_ready=1 || game_ready=0

  while (( ! $game_ready )); do
    game_ready=$(grep -c -m1 "$loaded_str" $ra_log)
  done

  #serialSend "VFD 7 READY!"

  #------------------------------------------------

  watch_credits "$game_listed"

  if [[ $game_listed -gt 0 ]]; then
    get_gamedata
    getAddr
  fi

  #------------------------------------------------

  while (( $retro_running )); do
    retro_running=$(ps -ef | grep -v grep | grep -c -m1 retroarch)
    coins_count=$(cat "$file_coins_count")
    start_count=$(cat "$file_start_count")
    serialSend "LCD 0 C: $coins_count, S: $start_count"
    sleep 1
    serialSend "LCD 1 CREDITS: $(( coins_count - start_count ))"
    sleep 1
  done

}

getAddr() {
  local scan_args='option region_scan_level 3;reset;lregions;exit'

  debug "\n\ngetAddr():\n"

  (( ! $testing )) && sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -P -A1000 '\[ 0\]' |& sed s'/[][,]//g' | sudo tee "$file_regionlist" &>/dev/null && sudo sed -i '/> exit/d' "$file_regionlist"

  while (( ! $credits )); do
    calc_credits
  done

  sleep 1

  for i in {1..3}; do
    get_regions "${data[NAME]}" $i
    if [[ $identified -gt 0 ]]; then
      debug "IDENTIFIED!" && break
    fi
  done

  serialSend "VFD 7       DONE!"

}

get_regions() {
  #local args="${@}"
  local region_list=$(cat "$file_regionlist")
  local region_count=$(cat "$file_regionlist" | wc -l)
  local reg_num=${data[NUM]}
  local range=5

  [[ ${#} -lt 2 ]] && iter=1 || iter=${2}
  [[ ${1} == code ]] && iter=$(( iter - 1 ))

  debug "get_regions()\n\targs (${#}): \x27${@}\x27, len: $region_count\n\n"
  debug "iter: $iter\n\n"

  if [[ $iter == 0 ]]; then
    reg_start=$reg_num
    reg_end=$(( reg_start + 1 ))

  elif [[ $iter == 1 ]]; then
    result=$(calc_range $reg_num $range)
    reg_start=$(echo "$result" | cut -d' ' -f1)
    reg_end=$(echo "$result" | cut -d' ' -f2); reg_end=$(( reg_end+1 ))

  elif [[ $iter -gt 1 ]]; then
    reg_start=1
    reg_end=$region_count
  fi

  debug "reg_num: $reg_num, reg_start: $reg_start, reg_end: $reg_end\n\n"

  for (( i=$reg_start; i<$reg_end; i++)); do
    line=$(awk -v ln="$(( i + 1 ))" 'NR==ln' "$file_regionlist" | awk '{$1=$1; print}')
    name=$(echo "$line" | awk '{print $5}')
    echo -n "$i ($name): "
    echo "$line" | awk '{print $1" "$2}'
    [[ $name == ${data[NAME]} ]] && regions+=("0x$(echo $line | awk '{print $2}')")
  done

  (( ! $testing )) && dump_addr
}

dump_addr() {
  for (( i=0; i<${#regions[@]}; i++)); do
    BASE="${regions[$i]}"
    OFFS="${data[OFFS]}"
    ADDR="";printf -v ADDR "0x%X\n" $(( BASE + OFFS)) &>/dev/null; ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
    VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')


    debug "\n\n\${regions[$i]}:"
    debug "\n\tBASE: $BASE\n\tOFFS: $OFFS\n\tADDR: $ADDR\n\tVAL: $VAL"

    calc_credits 1

    if [[ "$VAL" == "$credits_str" ]]; then
      debug "VAL == credits_str ($credits_str)"
      LASTVAL="$credits_str"

      printf -v credits_str '%02d' "$(( credits + 1 ))" &>/dev/null && debug "credits_str: $credits_str"
      sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $credits_str;exit" &>/dev/null
      sleep 1

      VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')

      calc_credits 1

      sleep 1

      sudo scanmem -p `pidof retroarch` -c"write i16 $ADDR $credits_str;exit" &>/dev/null

      debug "NEW: $VAL"

      if [[ ! $VAL == $LASTVAL ]]; then
        identified=1 && break
      fi

    fi
    debug " "
    #(( $identified )) && serialSend "VFD 7 IDENTIFIED!"

  done
}

get_gamedata() {
  local table_data=$(cat "$game_table" | grep -w "$game" | awk '{$1=$1;print}')

  data[GAME]=$(echo "$table_data" | awk '{print $1}')
  data[OFFS]=$(echo "$table_data" | awk '{print $2}')
  data[NUM]=$(echo "$table_data" | awk '{print $3}')
  data[NAME]=$(echo "$table_data" | awk '{print $4}')
  data[TYPE]=$(echo "$table_data" | awk -F'\[' '{print substr($2,0,length($2))}')

  debug "\n\nget_gamedata():\n"
  debug "DATA:\n"

  for i in "${!data[@]}"; do
    debug "$i:\t\t${data[$i]}"
  done
}


calc_range() {
  base=$1
  int=$2
  sum=$(( base - int ))

  if [[ $sum -le 0 ]]
  then start=1; end=$(( int+int ))
  else start=$sum; end=$(( base+int ))
  fi

  echo "$start $end"

}

calc_credits() {
  coins_count=$(cat "$file_coins_count")
  start_count=$(cat "$file_start_count")
  credits=$(( coins_count - start_count ))
  [[ $# > 0 ]] && printf -v credits_str '%02d' "$credits" &>/dev/null
}


watch_credits() {
  read_inputs &
}

read_inputs() {
  local coins_cnt=0
  local start_cnt=0

  local limit_start=20
  local t_start=$limit_start
  local last_start=$(date +%s)

  while read -r line; do
    pressed=$(echo "$line" | grep -E "$coin_key|$start_key" | \
      awk -v C="$coin_key" -v S="$start_key" '{
        if ($2 == C) print "COIN"
        if ($2 == S) print "START"
      }')

    coins_cnt=$(cat "$file_coins_count")
    start_cnt=$(cat "$file_start_count")

    if [[ $pressed == COIN ]]; then
      echo "$(( coins_cnt + 1 ))" | sudo tee $file_coins_count &>/dev/null
    elif [[ $pressed == START ]]; then
      if [[ $coins_cnt -gt 0 ]]; then
        if [[ $start_cnt -gt 0 ]]; then
          t_start=$(( `date +%s` - $last_start ))
          if [[ $t_start -ge $limit_start ]]; then
            echo "$(( start_cnt + 1 ))" | sudo tee $file_start_count &>/dev/null
            t_start=0
            last_start=$(date +%s)
          fi
        else
          echo "$(( start_cnt + 1 ))" | sudo tee $file_start_count &>/dev/null
          t_start=0
          last_start=$(date +%s)
        fi
      fi
    fi
  done< <(thd --dump "$teensy_kbd" 2>&1 |& grep --line-buffered -E "$coin_key|$start_key" | awk -W interactive '{$1=$1;print}' | grep --line-buffered -Ew "EV_KEY $coin_key 1|EV_KEY $start_key 1" 2>&1)
}

wipe() {
  file="$@"
  [[ ! -f "$file" ]] && sudo touch "$file" &>/dev/null \
  || echo -e "\n" | sudo tee "$file" &>/dev/null
  sudo chmod 775 "$file" &>/dev/null
  #debug "wipe(): $file\n"
}

vfd_format() {
  local title=$1
  local length=$(( $(echo "$title" | wc -m) - 1 ))
  local spacing=$(( (16 - $length) / 2 ))
  local str=""

  if [[ $spacing -lt 16 ]]; then
    for (( i=0;i<$spacing;i++ )); do
      str+=" "
    done
    str+="$title"
    mode=4
  else
    str="$title"
    mode=2
  fi

  debug "VFD - title : $title"
  debug "VFD - length: $length"
  debug "VFD - spacing: $spacing"
  debug "VFD - string: $str"

  serialSend "VFD $mode $str"
}

serialSend() {
 [ -c /dev/ttyACM0 ] && printf "${@}" > /tmp/pyserial.fifo #&>/dev/null
  sleep 1
}

cafca_scan() {
  sleep 1
}

press_key() {
  printf $@ > /tmp/vkbdd.fifo
}

debug() {
  (( $debug )) && echo -e "[DEBUG] $@"
}

cleanup() {
  debug "Cleaning up..."
  serialSend "GAME_STOPPED 1"
  (( $retro_running )) && printf '\033' >/tmp/vkbdd.fifo

  if (( $testing )); then
    rc_info_bak="$data_dir/tmp/runcommand.info.bak"
    ra_log_bak="$data_dir/tmp/retroarch.log.bak"
    regionlist_bak="$data_dir/tmp/regionlist.bak"
    sudo touch "$rc_info_bak" && sudo cp "$ra_log" "$rc_info_bak"
    sudo touch "$ra_log_bak" && sudo cp "$rc_info" "$ra_log_bak"
    sudo touch "$regionlist_bak" && sudo cp "$file_regionlist" "$regionlist_bak"

  fi
}

#_____________________________________________________
#
# SETUP
#
#-----------------------------------------------------

#CONSTS:

SCRIPT=$(readlink -f $0)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
DIR=$(cd $(dirname $SCRIPT) && pwd)
CALLER=$(cat /proc/$PPID/comm)

args=("$@")
root_user=

log_dir="$DIR/log"
log_file="$log_dir/CAFCA.log"
rc_log='/dev/shm/runcommand.log'
rc_info='/dev/shm/runcommand.info'
ra_log="$log_dir/retroarch/retroarch.log"

teensy_kbd='/dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'

data_dir="$DIR/data"
game_table="$data_dir/$system/game_table"

file_regionlist="$data_dir/tmp/regionlist"
file_coins_count="$data_dir/tmp/cafca_coins_cnt"
file_start_count="$data_dir/tmp/cafca_start_cnt"

bypass=$(grep bypass "$data_dir/.settings" | cut -d= -f2)

#---------------------------------------------------

(( ! $(id -u) )) && root_user=1 || root_user=0

wipe "$log_file"
wipe "$ra_log"

ra_log_owner=$(ls -l "$log_dir/retroarch" | grep "$(echo $ra_log | cut -d/ -f7)" | awk '{print $3" "$4}')

if [[ $ra_log_owner != "pi pi" ]]; then
  debug "setting log rights to pi:pi"
  sudo chown pi:pi "$ra_log"
fi

exec > >(sudo tee $log_file 2>&1)

debug "\n\nC A F C A\n\n`date '+%d/%m-%Y %T'`\n\nHOMEDIR:\t$HOMEDIR\nDIR:\t\t$DIR\nSCRIPT:\t\t$SCRIPT\nROOT USER:\t$root_user\nCALLER:\t\t$CALLER\n"

if [ "${#args[@]}" -gt 0 ]; then
  action=$(echo "$1" | tr '[:lower:]' '[:upper:]')
  [ "${#args[@]}" -gt 1 ] && mode=$(echo "$2" | tr '[:lower:]' '[:upper:]')
  testing=0
else
  debug "NO ARGS..\n"
fi

(( $debug )) && echo -e "_____________________________________________\n"

trap cleanup EXIT

#exit 0

wipe "$file_coins_count" && echo 0 | sudo tee "$file_coins_count" &>/dev/null
wipe "$file_start_count" && echo 0 | sudo tee "$file_start_count" &>/dev/null

if [[ $bypass -ne 1 ]]; then
  if (( ! $testing )); then
    wipe "$file_regionlist"
    Main
  else
    rc_info_bak="$data_dir/tmp/runcommand.info.bak"
    ra_log_bak="$data_dir/tmp/retroarch.log.bak"
    regionlist_bak="$data_dir/tmp/regionlist.bak"

    #[ -f $rc_info_bak ] && rc_info="$rc_info_bak"
    #[ -f $ra_log_bak ] && ra_log="$ra_log_bak"
    #[ -f $regionlist_bak ] && file_regionlist="$regionlist_bak"

    #rc_info="$DIR/tmp/runcommand.info.bak"
    #ra_log="$DIR/tmp/retroarch.log.bak"
    #file_regionlist="$DIR/tmp/regionlist.bak"

    cafca_dump
  fi
fi

exit 0

#____________________________________________________
