#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)


rom_dir='/home/pi/RetroPie/roms/mame-libretro'
list_dir="$SCRIPT_DIR"

gamelist='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
gun_games='/home/pi/.emulationstation/collections/custom-lightgun.cfg'
fav_games='/home/pi/.emulationstation/collections/custom-arkade.cfg'
game_count=$(grep -Ec '<game>' "$gamelist")

cleanString() {
 input="${1}"; word="${2}"
 echo "$input" | grep -E "<$word>" | awk '{$1=$1;print}' | sed "s/<$word>//g; s/<\/$word>//g"
}

dumpData() {
  for (( n=1; n<=$game_count; n++ )); do
    data=$(awk -v p="<game>" -v n="$n" '$0~p{i++}i==n' "$gamelist")
    title=$(cleanString "$data" 'name' | sed "s/\x27//g")
    date=$(cleanString "$data" 'releasedate');date="${date:0:4}"
    publisher=$(cleanString "$data" 'publisher');publisher=$(echo "$publisher" | cut -d, -f1)
    path=$(cleanString "$data" 'path');path=$(echo "$path" | cut -d\/ -f2)
    name=$(echo "$path" | cut -d. -f1)
    [[ $(grep -c "$rom_dir/$path" "$gun_games") -lt 1 ]] && type='JOY' || type='GUN'

    #cat ../.assets/list | grep -o '[^ ]*$' | cut -d\' -f2 | cut -d. -f1 | grep -o '[^/]*$'

    echo "'$name' '$title' '$date' '$publisher' '$type' '$rom_dir/$path'"

  done #| sudo tee "$list_dir/.list_all" &>/dev/null
}

makeLists() {
  for p in 'FAV' 'GUN'; do cat "$list_dir/.list_all" | awk -v filtr="$p" -F\' '{if ($8 == filtr) print $0;}' | sudo tee "$list_dir/.list_${p,,}" &>/dev/null; done

  for l in 'all' 'fav' 'gun'; do
    cat "$list_dir/.list_${l}" | sort -k 1,1 | awk '{split($0,a,"\x27"); if (++dup[a[2]] == 1) print $0;}' | sudo tee "$list_dir/.list_${l}" &>/dev/null
    grep -n '' "$list_dir/.list_${l}" | sed 's/:/ /g' | sudo tee "$list_dir/.list_${l}" &>/dev/null
    sudo chown pi:root "$list_dir/.list_${l}"; sudo chmod 775 "$list_dir/.list_${l}"
  done
}

sudo cp -R "$list_dir" "$list_dir.bak"
dumpData
#makeLists

exit
