#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)


rom_dir='/home/pi/RetroPie/roms/mame-libretro'
list_dir="../"

gamelist='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
gun_games='/home/pi/.emulationstation/collections/custom-lightgun.cfg'
fav_games='/home/pi/.emulationstation/collections/custom-arkade.cfg'
game_count=$(grep -Ec '<game>' "$gamelist")

cleanString() {
 input="${1}"; word="${2}"
 echo "$input" | grep -E "<$word>" | awk '{$1=$1;print}' | sed "s/<$word>//g; s/<\/$word>//g"
}

dumpData() {
  for (( n=1; n<=$game_count; n++ )); do
    data=$(awk -v p="<game>" -v n="$n" '$0~p{i++}i==n' "$gamelist")
    title=$(cleanString "$data" 'name' | sed "s/\x27//g")
    date=$(cleanString "$data" 'releasedate');date="${date:0:4}"; [[ ${#date} -lt 1 ]] && date='19xx'
    publisher=$(cleanString "$data" 'publisher');publisher=$(echo "$publisher" | cut -d, -f1); [[ ${#publisher} -lt 1 ]] && publisher='<unknown>'
    path=$(cleanString "$data" 'path');path=$(echo "$path" | cut -d\/ -f2)
    name=$(echo "$path" | cut -d. -f1)
    [[ $(grep -c "$rom_dir/$path" "$gun_games") -lt 1 ]] && type='JOY' || type='GUN'
    echo -n "'$name' '$title' '$date' '$publisher' '$type' '$rom_dir/$path' '[ ALL "
    [[ $(grep -c "$path" "$fav_games") -gt 0 ]] && echo -n "FAV "
    [[ "${type}" == GUN ]] && echo -n "${type} "; echo "]'"
  done | sudo tee "$list_dir/list" &>/dev/null
}

makeLists() {
  cat "$list_dir/list" | sort -k 1,1 | awk '{split($0,a,"\x27"); if (++dup[a[2]] == 1) print $0;}' | sudo tee "$list_dir/list" &>/dev/null
  cat "$list_dir/list" | awk -F\' '!a[$4]++' | sudo tee "$list_dir/list" &>/dev/null
  grep -n '' "$list_dir/list" | sed 's/:/ /g' | sudo tee "$list_dir/list" &>/dev/null
  sudo chown pi:root "$list_dir/list"; sudo chmod 775 "$list_dir/list"
}

sudo cp -R "$list_dir/list" "$list_dir/list.bak"
dumpData
makeLists

exit
