#!/bin/bash

include_file='/home/pi/ADMIN/.sys/include.sh'
declare -a nav=()
nav[0]='MAIN'
navstring='MAIN >'

level=0
selection=''
#resultKey=

function Main() {
   showMenu "${!mainArr[@]}"

   while true; do
     [ ${#returnArr[@]} -gt 0 ] && showMenu "${returnArr[@]}" || break
     #echo -e "user selected $resultKey\n"
   done
}

function showMenu() {
    returnArr=()
    newArr=()
    choices=()
    array=(${@})
    count=0

    for key in "${!array[@]}"
    do
       choices+=($(echo -e "$count ${array[$key]}")) &>/dev/null
       count=$(( count + 1 ))
    done

    result=$(whiptail --title "ADMIN MENU" --menu "$navstring" 16 36 8 "${choices[@]}" 3>&1 1>&2 2>&3)
    rc=$?

    quit_true=0
    if [ $rc -gt 0 ]; then
      nav["$level"]=''
      navstring=$(echo "${nav[*]}" | sed 's/ / > /g')
      if [ $level -gt 0 ]; then
        [ ${#prevArr[@]} -gt 0 ] && newArr=("${prevArr[@]}") || quit_true=1
        level=$((level - 1))
      else quit_true=1
      fi
    else
      prevArr=("${array[@]}")
      resultKey="${array[$result]}"
      newArr=($(echo -n "${mainArr[$resultKey]}"))
      #whiptail --title "Option 1" --msgbox "You chose option $result ($resultKey). \nExit status $?" 8 45
      level=$((level + 1))
      nav["$level"]="$resultKey"
      navstring=$(echo "${nav[*]}" | sed 's/ / > /g')
    fi

    [ $quit_true -gt 0 ] && exit

    returnArr=("${newArr[@]}")
    if [ ${#returnArr[@]} -lt 1 ]; then
      runCommand "$resultKey"
      nav=();nav[0]='MAIN'
      navstring='MAIN >'
      level=0
      showMenu "${!mainArr[@]}"
      #return
    fi
}

showSubMenu() {
  choices=()
  count=0
  arr_name=$(echo "$1_$2" | tr [A-Z] [a-z])

  #echo -e "\narr_name: $arr_name"
  eval "sub_arr=(\"\${$arr_name[@]}\")"

  for key in "${!sub_arr[@]}"; do
    str="${sub_arr[$key]}"
    entry=$(echo "$str" | cut -d';' -f1)
    #entry=$(echo -e "\x22$entry\x22")
    cmd=$(echo "$str" | cut -d';' -f2)
    #echo -e "\nsys_video\n-str: $str\n-entry: $entry\n-cmd: $cmd"
    subArr["$entry"]="$cmd"
  done

  #echo -e "\nSUBARR KEYS: ${!subArr[@]}\n"
  #echo -e "\nSUBARR VALS: ${subArr[@]}\n"

  for key in "${!subArr[@]}"
  do
    choices+=($(echo -e "$count $key")) &>/dev/null
    count=$(( count + 1 ))
  done
  echo "CHOICES: ${choices[2]}"
  sub_result=$(whiptail --title "ADMIN MENU" --menu "SUB:" 16 36 8 "${choices[@]}" 3>&1 1>&2 2>&3)
  rc=$?
  command=$(echo "${sub_arr[$sub_result]}" | cut -d';' -f2)
  echo "COMMAND: $command"

  #exit

#case $key in
#  'VIDEO_MODE')
#   ;;
# *)
#   ;;
#esac

}

runCommand() {
  args=(${@})
  nav_str="${nav[*]}"
  navstring=$(echo "${nav[*]}" | sed 's/ / > /g')
  parent=$(echo "$nav_str" | cut -d' ' -f2)
  key=$1
  #echo -e "\nnav: $navstring; parent: $parent; level: $level; key: $key"
  sleep 2
  #whiptail --title "$navstring" --msgbox "HERRO" 8 45
  #return

  case $parent in
     'SETUP')
        pre_str='stp'
        showSubMenu $pre_str $key
       ;;
     'TOOLS')
        pre_str='tls'
        showSubMenu $pre_str $key
       ;;
     'SYSTEM')
        pre_str='sys'
        showSubMenu $pre_str $key
        #rc=$(showSubMenu $pre_str $key);echo -e "\nRC: $rc"
       ;;
     'GAMES')
        pre_str='gam'
        showSubMenu $pre_str $key
       ;;
     *)
       echo -e "\nNot a valid option."
       ;;
  esac
}

##################################

[ -f $include_file ] \
&& source $include_file
include

#[ "$INCLUDED" ] \
#&& echo "succes!" \
#|| echo "failure" && exit 1

declare -a systemArr=('VIDEO_MODE' 'SHOW_LOGS' 'REBOOT')
declare -a setupArr=('CLEAN_INSTALL' 'CAFCA_SETUP' 'EMULATION')
declare -a toolsArr=('MC' 'EMULATIONSTATION' 'CONFIG_INFO')
declare -a gamesArr=($(cat /home/pi/CAFCA/data/.gamelist))

declare -A mainArr=( \
  [SYSTEM]="${systemArr[@]}" \
  [SETUP]="${setupArr[@]}" \
  [GAMES]="${gamesArr[@]}" \
  [TOOLS]="${toolsArr[@]}" \
)

declare -A subArr=()

#declare -a sys_video=("0 SELECT_VIDEO_MODE; bash /home/pi/pat.sh")
#declare -a sys_video_mode=()

declare -a sys_video_mode+=( \
  "SELECT_VIDEO_MODE; bash /home/pi/pat.sh" \
  "SOMETHING_ELSE; run myprogram.exe" \
)


#declare -A arr_sys_video=( \
#  ['SETUP']='' \
#)

#declare -a pages
declare -a returnArr
declare -a prevArr


Main


##################################


#  result=$(
#     #whiptail --backtitle "$backtitle" \
#     whiptail --title "Select Game" \
#           --menu "$text"      \
#           0 0 0 "${mainArr[@]}"    \
#           3>&2 2>&1 1>&3
#  );
#}

