#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$DIR/../.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"

PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# VARIABLES
list=(); indexes=(); timers=();
pageIndex=0; total_files=0; offset=0; active=0; prev=0
timer=0; idle_state=0; init=1; busy=0;

pages=($(awk -F'\[|\]' '{print $2}' "$list_path" | sed 's/[ ]/\n/g;' | sed ' /^$/d' | sort -u)); pages+=("ALL")
pageTitles=(' ^^ TOP GAMES ^^' ' ** GUN GAMES **' ' || ALL GAMES ||')
page="${pages[$pageIndex]}"

width=$(echo "$(tput cols)");  [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 2 ))

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#OPTIONS
hide_term=1;	screensaver=0
colors=1;	center=1
play_music=1;	snd_vol=10

t_title=2
t_saver=$(grep -w -m1 'saver_timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
t_sleep=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

#t_saver=30; 	t_sleep=60;

#________________________________________________________________________________________________________________________________________________


Main() {
  sendSerial "VFD 6  W E L C O M E "
  setPage

  while true; do
    input=$(readInput)
    if [[ ${#input} -gt 0 ]]; then
      navigate "$input"
    else
      if [[ $(elapsed) -ge ${timers[$idle_state]} ]]; then
	case $idle_state in
	  0) [[ $init -eq 0 ]] && showTitle ;;
	  1) [[ $screensaver -gt 0 ]] && screenSaver ;;
	  2) ;;
	  *) ;;
	esac
        [[ $idle_state -lt ${#timers[@]} ]] && (( idle_state++ ));
      fi
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  case "${1^^}" in
    'UP')
	prev=$active
	[[ $(( active + offset )) -gt 0 ]] && { \
	  (( active-- )); drawScreen; init=0; \
        }
	;;
    'DOWN')
	prev=$active
	[[ $(( active + offset )) -lt $(( total_files - 1 )) ]] && { \
	  (( active++ )); drawScreen; init=0; \
	}
	;;
    'LEFT')
	(( pageIndex-- )); changePage; init=1
	;;
    'RIGHT')
	(( pageIndex++ )); changePage; init=1
	;;
    'ENTER')
	launchGame; init=1; #makeList; active=$prev; drawScreen; init=1
	;;
    'SPACE')
	prev=$active; slideshow; init=1 #drawScreen;
	;;
     'S')
	launchGame; init=1; #makeList; active=$prev; drawScreen; init=1
	;;
    'ESC')
	exit 0
	;;
  esac
  idle_state=0; elapsed 0;
}

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

drawScreen() {
  if [[ $active -lt 0 ]] && [[ $offset -gt 0 ]]; then
    offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ))
  elif [[ $active -ge ${#list[@]} ]]; then
    offset=$(( offset + maxPage )); makeList; active=0
  fi
  markLine
}

makeList() {
  list=()

  for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4)
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do printer "${list[$i]}" 0; done; echo ""
}

changePage() {
  [[ $pageIndex -lt 0 ]] && pageIndex=$(( ${#pages[@]} - 1 )) || { \
  [[ $pageIndex -ge ${#pages[@]} ]] && pageIndex=0; }

  page="${pages[$pageIndex]}"; sendSerial "VFD 3 ${pageTitles[$pageIndex]}" #sendSerial "VFD 3 ${pageTitles[$page]}"
  setPage
}

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  total_files=${#indexes[@]}; offset=0

  clear; active=0; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  [[ $page == ALL ]] && pg='FAV' || pg="$page"
  id_list=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  entry=$(( ( offset + active ) + 1 )); val=0

  fim -N -T 1 -d /dev/fb0 \
   -C $entry \
   --quiet \
   --execute-script "$assets_path/config/fim_slideshow.txt" \
   --read-from-stdin< <( \
	for i in "${id_list[@]}"; do \
     	  name=$(sed "${i}q;d" "$list_path" | cut -d\' -f2); \
     	  find "$assets_path/media/slideshow/mame-libretro/$name" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null; \
   	done ) > "$assets_path/slideshow.log"

  line_count=$(cat "$assets_path/slideshow.log" | wc -l )
  for ((n=$line_count; n>0; n-- )); do
    val=$(sed "${n}q;d" "$assets_path/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { val=$(( val - 1 )); break; }
  done

  offset=$(( (val / maxPage) * maxPage )); active=$(( val - offset ))

  game=$(sed "${indexes[$val]}q;d" "$list_path" | cut -d\' -f2)
  [[ $(sed '$!d' "$assets_path/slideshow.log") =~ "$game" ]] && launchGame

  makeList; markLine

  #idx=${indexes[$val]}; game=$(sed "${idx}q;d" "$list_path" | cut -d\' -f2)
  #[[ $(sed '$!d' "$assets_path/slideshow.log") =~ "$game" ]] && sendSerial "VFD 1 $game"

  #sendSerial "VFD 2 ACT: $active,OFFS: $offset"
  #list=()
  #for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
  #  [[ $i -ge $total_files ]] && break
  #  title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4)
  #  list+=("$title")
  #done
  #clear
  #for (( i=0; i<${#list[@]}; i++ )) ; do
  #  [[ $i == $active ]] && mark=1 || mark=0
  #  printer "${list[$i]}" $mark
  #done
}

launchGame() {
  entry=$(( offset + active ))
  idx=${indexes[$entry]}
  path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)

  if [ -f "$path" ]; then
    system=$(echo "$path" | awk -F/ '{print $(NF-1)}')
    game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)
    sudo sed -i "/ACTIVE_GAME/ s/ACTIVE_GAME[=].*$/ACTIVE_GAME=\x27${system}\/${game}\x27/" "$HOMEDIR/CAFCA/data/.states"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game

    sudo -u pi bash -c  "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} $system dummy"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu

    sudo setterm --cursor off
  fi
}

screenSaver() {
  video_path="$media_path/screensaver/vid/arcade.mp4"

  if [ -e "$video_path" ]; then
    [[ $play_music -gt 0 ]] && playMusic
    omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.txt" "$video_path" >/dev/null 2>&1
    [[ $play_music -gt 0 ]] && sudo killall ffplay
    drawScreen
  fi
}

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path="$media_path/audio/music/Live_to_tell.mp3"
  [ -e "$music_path" ] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

showTitle() {
  entry=$(( offset + active ));
  idx=${indexes[$entry]}
  title=$(awk -F'\x27' -v l="$idx" 'NR==l {print $4,"("$6")","["$8"]"}' "$list_path")
  sendSerial "VFD 1 $title"
}

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      #[[:graph:]])      Event="$Event1" ;;
      $'\163')	        Event="S"	;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"; pad=''; str=''

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"
  echo -e "${str}"
}

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

elapsed() {
  [ $# -gt 0 ] \
  && timer=$(echo $(( 10#$(date +%s) ))) \
  || echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

bgTimer() {
  timeout=$t_sleep

  while :; do
    start=$(echo $(( 10#$(date +%s | tail -c 4) )))
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(echo $(( 10#$(date +%s | tail -c 4) )))
    elapsed=$(echo $(( 10#$(( end - start )) )) )

    # if pgrep -c retroarch -lt 1:
    if [[ $elapsed -ge $timeout ]]; then
      sendSerial "ASLEEP 1"
      while read line; do break; done< <(thd --dump /dev/input/event*)
      sendSerial "ASLEEP 0"
    fi
  done
}

Init() {
  timers=( "$t_title" "$t_saver" "$t_sleep" )

  trap 'exitFunc' EXIT SIGINT INT

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu

  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }

  elapsed 0
  bgTimer &
}

exitFunc() {
  [[ $hide_term -eq 1 ]] && { export PS1="$PS1_STORED"; stty -F /dev/tty1 sane; sudo setterm --cursor on; }

  sendSerial "VFD 3  G O O D B Y E "

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term

  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  clear
  exit
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init
Main

exit


slideshow2() {
  entry=$(( ( offset + active ) + 1 ))

  #[ -e "$fav_path" ] && list=($(cat "$list_path" | grep -o '[^/]*$' | cut -d\' -f1 | cut -d. -f1));

 slide_list=($(for i in "${indexes[@]}"; do sed "${i}q;d" "$list_path" | cut -d\' -f2))


  fim -N -T 1 -d /dev/fb0 \
   -C $offset \
   --quiet \
   --execute-script "$assets_path/config/fim_slideshow.txt" \
   --read-from-stdin< <( \
        for l in "${list[@]}"; do \
          find "$assets_path/media/slideshow/mame-libretro/$l" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit \
          2>/dev/null; \
        done ) > "$assets_path/slideshow.log"


  line_count=$(cat "$SCRIPT_DIR/slideshow.log" | wc -l )
  for ((n=$line_count; n>0; n-- )); do
    val=$(sed -n ''"$n"'p' "$SCRIPT_DIR/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { active=$val; active=$(( active - 1 )); break; }
  done

  selected_game=$(getEntry 'name')
  [[ $(sed -n '$p' "$SCRIPT_DIR/slideshow.log") =~ "$selected_game" ]] && { \
    launchGame; init=1; idle_state=0; drawScreen 1; \
  }
}
