#!/bin/bash

# -------------------------------------------------------------------------------------------


HOMEDIR='/home/pi'

declare -A options=( [T_SLEEP]=10 )

sendSerial() {
  [ $# -gt 0 ] && echo -e "$@" > /tmp/serial.fifo || return
}

checkKeypress() {
  timeout=${options[T_SLEEP]}

  #while :; do
    start=$(printf `date '+%s'` | tail -c 4)
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(printf `date '+%s'` | tail -c 4); elapsed=$(( end - start ))
    echo "$elapsed" # REM
    if [[ $elapsed -ge $timeout ]]; then
      sendSerial "ASLEEP 1"
      while read line; do break; done< <(thd --dump /dev/input/event*)
      sendSerial "ASLEEP 0"
    fi
  #done
}

checkKeypress
echo "DONE"
exit


# -------------------------------------------------------------------------------------------

# ADVANCED

HOMEDIR='/home/pi'

declare -A options=( [T_SLEEP]=10 )

sendSerial() {
  [ $# -gt 0 ] && echo -e "$@" > /tmp/serial.fifo || return
}

checkKeypress() {
  timeout=${options[T_SLEEP]}

  #while :; do
    start=$(printf `date '+%s'` | tail -c 4)
    #sudo timeout $timeout bash -c 'thd --dump /dev/input/event* | head -n 1 >/dev/null'
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(printf `date '+%s'` | tail -c 4); elapsed=$(( end - start ))
    echo "$elapsed" # REM
    if [[ $elapsed -ge $timeout ]]; then
      sendSerial "ASLEEP 1"
      while read line; do break; done< <(thd --dump /dev/input/event*)
      #thd --dump /dev/input/event* | head -n 1 >/dev/null
      sendSerial "ASLEEP 0"
    fi

    #[[ $elapsed -lt $timeout ]] && echo "$elapsed" || sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" mode sleep
  #done
}

checkKeypress
#clear && \
echo "DONE"
exit


# -------------------------------------------------------------------------------------------

# SIMPLE

declare -A options=( \
  [T_SLEEP]=10 \
)

checkKeypress() {
  timeout=${options[T_SLEEP]}

  #while :; do
    start=$(printf `date '+%s'` | tail -c 4)
    sudo timeout $timeout bash -c 'thd --dump /dev/input/event* | head -n 1 >/dev/null'
    end=$(printf `date '+%s'` | tail -c 4); elapsed=$(( end - start ))
    echo "$elapsed"
    [[ $elapsed -ge $timeout ]] && echo "TIMEOUT"
  #done
}

checkKeypress
