#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"

height=$(( ( $(tput lines) - 2) / 2 )); echo "$height"
pg='FAV'
items=($(cat "$DIR/../.assets/list" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[2]}')); echo ${#items[@]}

offset=0; active=0

drawScreen() {
clear
for (( i=$offset; i<$(( offset + height)); i++ )); do
  [[ $i -ge ${#items[@]} ]] && break
  item=$(echo "${items[$i]}" | sed 's/\x27//g')
  [[ $i == $active ]] && item="${MARK}${item}${UNMARK}"
  echo "${item}"
done
echo "active: $active"
#for item in ${items[@]}; do
}

nav() {
 [[ $active -ge $height ]] && offset=$(( offset + height ))
 drawScreen
}

drawScreen

while :; do read -rs -N 1 -t 0.1 input; [[ ${#input} -gt 0 ]] && { read -t 0.01 -rsn5 in; case "$in" in "[A") (( active--)); nav  ;; "[B") (( active++ )); nav ;; esac; }; done

exit

#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
