#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

cafca_path='/home/pi/CAFCA'
gamelist='/home/pi/.emulationstation/collections/custom-arkade.cfg'
data_file='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
rom_dir='/home/pi/RetroPie/roms/mame-libretro'
list_path="$SCRIPT_DIR/.lists/.list_all"
art_path="$SCRIPT_DIR/.assets"

C="$(echo -e "\033[32m")"; NC="$(echo -e "\033[0m")"; MARK="$(echo -e "\e[7m")"; UNMARK="$(echo -e "\e[0m")"
PS1_stored="$PS1"; export PS1='\[$(tput sgr0)\]\[$(tput sgr0)\] '

printf '' | sudo tee "$SCRIPT_DIR/errors.log" >/dev/null 2>&1
exec 2> "$SCRIPT_DIR/errors.log"

# ------------------------------------------------------------------------------------------------

# options:

title_timeout=1
art_timeout=3
screen_sleep=60
system_sleep=$(grep -w -m1 timeout "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

center=1
animate=1
drawDelay=0.125
slideshow=0
splashscreen=0

# ------------------------------------------------------------------------------------------------

# globals:

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 )); height=$(echo "$(tput lines)")
maxItems=$(( height - 1 ))

index=0; offset=0; count=0; idle_state=0; asleep=0; init=1; first_boot=1; active=1

page_titles=( '  T O P  L I S T' ' L I G H T G U N' 'A L L  G A M E S"')
pages=('fav' 'gun' 'all')

page="${pages[$index]}"
list_path="$SCRIPT_DIR/.lists/.list_${page}"

total_files=$(( $(cat "$list_path" | wc -l) ))
#total_files=$(( $(cat "$list_path" | wc -l) - 1 ))

timers=( \
  "$(( title_timeout * 10 ))" \
  "$(( art_timeout   * 10 ))" \
  "$(( screen_sleep  * 10 ))" \
  "$(( system_sleep  * 10 ))" \
)

files=()
input=''

# ------------------------------------------------------------------------------------------------


Main() {
  echo -e "VFD 3  GAMES MENU v1.0" > /tmp/serial.fifo

  create_gallery

  [[ $splashscreen -gt 0 ]] && showSplash 5
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 1 ]]; then
      count=0; screenState 1
      navigate "$input"
    else
      count=$(( count + 1 ));

      if [[ $count -gt ${timers[$idle_state]} ]]; then
        [[ $idle_state -eq 0 ]] && [[ $init -eq 0 ]] && showTitle #{ showTitle; (( idle_state++ )); }
        [[ $idle_state -eq 1 ]] && [[ $slideshow -gt 0 ]] && showArtwork #{ showArtwork; (( idle_state++ )); }
        [[ $idle_state -eq 2 ]] && screenState 0; #{ screenState 0; (( idle_state++ )); }
        [[ $idle_state -eq 3 ]] && [[ $asleep -eq 0 ]] && screenState 'sleep'
        [[ $idle_state -lt 3 ]] && idle_state=$(( idle_state + 1 ))
      fi
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  images=($(cat "$SCRIPT_DIR/.lists/.list_fav" | grep -o '[^/]*$' | cut -d\' -f1 | cut -d. -f1));
  index=$(( ( offset + active ) + 1 ))

  fim -N -T 1 -d /dev/fb0 -N \
    --execute-script "$SCRIPT_DIR/script.txt" \
    --read-from-stdin< <( for l in "${images[@]}"; do find "$SCRIPT_DIR/.assets/mame-libretro/$l" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null; done )

  #fim -N -T 1 -d /dev/fb0 -N \
  #  --execute-script "$SCRIPT_DIR/script.txt" \
  #  --read-from-stdin< <( for l in "${images[@]}"; do find "$SCRIPT_DIR/.assets/mame-libretro/$l" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null; done )
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1; [[ $? -gt 127 ]] && return

    case "$Event1" in
      [[:graph:]])      Event="$Event1" ;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

getEntry() {
  entry=$(( ( offset + active ) + 1 ))
  str=$(sed -n ''"$entry"'p' "$list_path" | grep -o '[^ ]*$' | cut -d\' -f2)
  if   [[ "${1}" == name   ]]; then
    echo "$str" | grep -o '[^/]*$' | cut -d. -f1
  elif [[ "${1}" == system ]]; then
    echo "$str" | awk -F/ '{print $(NF-1)}'
  else
    echo "$str"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

dumpEntry() {
  entry=$(( ( offset + active ) + 1 ))
  str=$(sed -n ''"$entry"'p' "$list_path" | grep -o '[^ ]*$' | cut -d\' -f2)
  #echo "$entry $str" | sudo tee -a "$SCRIPT_DIR/dump.log" >/dev/null 2>&1
  showImage $entry
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  init=0
  #closeImage # && drawScreen

  case "${1}" in
    'UP')
	active=$(( active - 1 )); idle_state=0
        drawScreen
	;;
    'DOWN')
	active=$(( active + 1 )); idle_state=0
        drawScreen
	;;
    'LEFT')
	[[ $index -gt 0 ]] && index=$(( index - 1 ))
         setPage
	;;
    'RIGHT')
	[[ $index -lt $(( ${#pages[@]} - 1 )) ]] && index=$(( index + 1 ))
         setPage
	;;
    'ENTER')
        path=$(getEntry)
        launchGame "$path"; init=1; idle_state=0
        drawScreen
	;;
    'SPACE')
        slideshow
        #dumpEntry
        #showArtwork
	;;
    'F4')
        echo -e "VFD 3  G O O D B Y E !" > /tmp/serial.fifo
        clear && exit 0
    	;;
  esac
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

launchGame() {
  [ $# -gt 0 ] && path="${1}"
  if [ -f "$path" ]; then
    system=$(echo "$path" | awk -F/ '{print $(NF-1)}')

    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" game "${path}" "$0"
    python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py "${path}" "$system" dummy
    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" menu '' "$0"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  list=()
  while read line; do
    list+=("$(echo $line | cut -d\' -f2)")
  done< <(cat "$list_path" | sed -n ''"$(( offset + 1 ))"','"$(( offset + maxItems ))"'p')
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  [[ $(( active + offset )) -gt $total_files ]] && active=$(( active - 1 ))

  if [[ $active -gt $(( ${#list[@]} - 1 )) ]]; then
    if [[ $(( offset + maxItems )) -lt $total_files ]]; then
      offset=$(( offset + maxItems )); active=0; makeList
    fi
  fi
  if [[ $active -lt 0 ]]; then
    if [[ $offset -gt 0 ]]; then
        offset=$(( offset - maxItems )); active=$(( maxItems - 1 )); makeList
    else
      active=0
    fi
  fi

  clear
  [[ $init -eq 1 ]] && sleep 0.5

  for (( i=0; i<${#list[@]}; i++ )) ; do
    [[ $i == $active ]] && marked=1 || marked=0
    printer "${list[$i]}" $marked
    [[ $init -eq 1 ]] && { [[ $i -gt 3 ]] && sleep 0.1 || sleep 0.2; }
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  active=0; offset=0; init=1

  page="${pages[$index]}"
  list_path="$SCRIPT_DIR/.lists/.list_${page}"
  #total_files=$(( $(cat "$list_path" | wc -l) - 1 ))
  total_files=$(( $(cat "$list_path" | wc -l) ))

  [[ $first_boot -gt 0 ]] && first_boot=0 || echo -e "VFD 0 ${page_titles[$index]}" > /tmp/serial.fifo

  makeList
  drawScreen
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showSplash() {
  imageTime="${1}"
  file="$HOMEDIR/downloads/artwork/splash1.jpg"

  fbi -a -T 1 -d /dev/fb0 --noverbose "$HOMEDIR/downloads/artwork/splash1.jpg" >/dev/null 2>&1 &
  sleep "$1" #&& closeImage #; clear
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showTitle() {
  entry=$(( ( offset + active ) + 1 ))
  line=$(sed -n ''"$entry"'p' "$list_path" | awk '{$1=$1;print}')

  title=$(echo -n "$line" | cut -d\' -f2)
  date=$(echo -n "$line" | cut -d\' -f4)
  pub=$(echo -n "$line" | cut -d\' -f6)
  serial_str="$title ($date) [$pub]"

  echo -e "VFD 1 $serial_str" > /tmp/serial.fifo
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

screenState() {
  if [[ $1 == sleep ]]; then
    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" sleep &
    asleep=1
  else
    [[ $1 -eq 0 ]] && { sudo -- bash -c "setterm --blank force --term linux </dev/tty1"; drawScreen; } #{ closeImage && sudo setterm --blank force --term linux; }
    [[ $1 -eq 1 ]] && { sudo -- bash -c "setterm --blank poke --term linux </dev/tty1"; } #{ sudo setterm --blank poke  --term linux; }
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return

  txt="${1}"; mark="${2:-0}"; pad=''
  str="${C}${txt}"

  if [[ $center -gt 0 ]]; then
    strlen=${#str}; [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 )); strlen=$(( strlen / 2 ))
    length=$(( width / 2 )); length=$(( length - strlen )); printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";  str+="${NC}"

  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  export PS1="$PS1_stored"
  sudo setterm --cursor on
  #closeImage
  #sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" term '' "$0"
  exit
}

# ---------------------------------------------------------------------------------------------------------------



#[ ! -f "$SCRIPT_DIR/.lists/.list_all" ] && { echo "Creating list.."; sudo bash "$SCRIPT_DIR/.create_list.sh"; }

sudo setterm --cursor off
bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" menu '' "$0"
trap 'exitFunc' EXIT SIGINT INT

#sudo rm "$SCRIPT_DIR/log/stdout.log" >/dev/null 2>&1

#Main
slideshow
exit





# ---------------------------------------------------------------------------------------------------------------







showImage() {
 [ $# -gt 0 ] && index=$1 || index=1

  name=$(getEntry 'name'); system=$(getEntry 'system')
  file=$(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null)
  echo "$index -> $file" | sudo tee -a "$SCRIPT_DIR/dump.log" >/dev/null 2>&1

  fim "$file"

  #fim \
  #  -C $index \
  #  --autotop \
  #  --write-scriptout "$SCRIPT_DIR/fim.log" \
  #  --read-from-stdin < <(for f in /home/pi/downloads/artwork/*; do echo $f; done)
}


slideshow_old() {
  #sudo bash "/home/pi/ADMIN/CMD/STATE/STATE.sh" slide '' "$0"

  index=$(( ( offset + active ) + 1 ))

  fim \
    -C $index \
    --autotop \
    --read-from-stdin < <(for f in "${files[@]}"; do echo $f; done)

  #fim --read-from-stdin < <(for f in "${files[@]}"; do echo $f; done) #  --write-scriptout "$SCRIPT_DIR/fim.log"


  #sudo bash "/home/pi/ADMIN/CMD/STATE/STATE.sh" menu '' "$0"
}

closeImage() {
 if [[ $(ps -fC fbi | grep -c fbi) -gt 0 ]]; then
   sudo killall -15 fbi >/dev/null 2>&1
   [[ $1 -gt 0 ]] && sleep $1
   #drawScreen
 fi
}

showArtwork() {
  name=$(getEntry 'name'); system=$(getEntry 'system')
  files=($(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' 2>/dev/null))

  [[ ${#files[@]} -gt 0 ]] && file="${files[0]}" || return; [ ! -f "$file" ] && return

  [[ $(ps -fC fbi | grep -c fbi) -gt 0 ]] && { closeImage 1; } #drawScreen; }

  (sudo fbi -a -T 1 -d /dev/fb0 --noverbose "$file" >/dev/null 2>&1) &>/dev/null &
  #sudo fbi -a --noverbose "${files[@]}" >/dev/null 2>&1 &

  #sudo fbi -a -T 1 -d /dev/fb0 --noverbose "${files[@]}" >/dev/null 2>&1
  #(sudo fbi -a -T 1 -d /dev/fb0 --noverbose "${files[@]}" >/dev/null 2>&1) &>/dev/null &
}

showArtwork_new2() {
  name=$(getEntry 'name'); system=$(getEntry 'system')
  files=($(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' 2>/dev/null))
  #file="$art_path/${system}/${name}/${name}.jpg"

  [[ ${#files[@]} -gt 0 ]] && file="${files[0]}" || return
  [ ! -f "$file" ] && return

  [[ $(ps -fC fbi | grep -c fbi) -gt 0 ]] && closeImage 1

  while [[ $pressed -lt 1 ]]; do #&& [[ $idle_state -eq 2 ]]; do
    sudo fbi -a -d /dev/fb0 -t 3 --once --noverbose "${files[@]}" >/dev/null 2>&1 &
    sleep 5
  done
  #wait $? #&& echo -e "VFD 6 DONE!" > /tmp/serial.fifo
  #sleep 5
  #[ -f "$file" ] && sudo -- bash -c "fbi -a -t 3 --once --noverbose ${files[@]}"
  #[ -f "$file" ] && sudo fbi -a -t 5 --once --noverbose "${files[@]}" >/dev/null 2>&1

  #while [[ $pressed -lt 1 ]]; do #&& [[ $idle_state -eq 2 ]]; do
    #[ -f "$file" ] && sudo fbi -a -T 1 -d /dev/fb0 -t 2 --once --noverbose "$file" >/dev/null 2>&1
    #sudo fbi -a -T 1 -d /dev/fb0 --noverbose "${files[@]}" >/dev/null 2>&1 &
  #done
  #closeImage
}

showArtwork_new() {
  name=$(getEntry 'name'); system=$(getEntry 'system'); pressed=0
  files=($(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' 2>/dev/null))

  while [[ $pressed -lt 1 ]] && [[ $idle_state -eq 2 ]]; do
    closeImage && sleep 0.5
    sudo fbi -a -T 1 -d /dev/fb0 -t 1 --once --noverbose "${files[0]}" >/dev/null 2>&1 #&>/dev/null &
    #sudo fbi -a -T 1 -d /dev/fb0 --noverbose "${files[@]}" >/dev/null 2>&1) &>/dev/null &
  done
}

showArtwork_bak() {
  name=$(getEntry 'name'); system=$(getEntry 'system')
  files=($(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' 2>/dev/null))

  [[ $(ps -fC fbi | grep -c fbi) -gt 0 ]] && { closeImage; sleep 1; }
  sudo fbi -a -T 1 -d /dev/fb0 --noverbose "${files[@]}" >/dev/null 2>&1
  #(sudo fbi -a -T 1 -d /dev/fb0 --noverbose "${files[@]}" >/dev/null 2>&1) &>/dev/null &
}

# ---------------------------------------------------------------------------------------------------------------
