#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

list_path="$SCRIPT_DIR/.lists/.list_all"
art_path="$SCRIPT_DIR/.assets"

C="$(echo -e "\033[32m")"; NC="$(echo -e "\033[0m")"; MARK="$(echo -e "\e[7m")"; UNMARK="$(echo -e "\e[0m")"

#cafca_path='/home/pi/CAFCA'
#gamelist='/home/pi/.emulationstation/collections/custom-arkade.cfg'
#data_file='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
#rom_dir='/home/pi/RetroPie/roms/mame-libretro'
#printf '' | sudo tee "$SCRIPT_DIR/errors.log" >/dev/null 2>&1
#exec 2> "$SCRIPT_DIR/errors.log"

# ------------------------------------------------------------------------------------------------

# options:

center=1
animate=1
drawDelay=0.125

title_timeout=1
art_timeout=5
screen_sleep=15
system_sleep=30
#screen_sleep=$(grep -w -m1 saver_timeout "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
#system_sleep=$(grep -w -m1 timeout "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

splashscreen=1
screensaver=1
auto_images=0
hide_term=0

# ------------------------------------------------------------------------------------------------

# globals:

index=0; offset=0; count=0; idle_state=0; asleep=0; powerState=1; init=1; first_boot=1; active=1

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 )); height=$(echo "$(tput lines)")
maxItems=$(( height - 1 ))

page_titles=( '  T O P  L I S T' ' L I G H T G U N' 'A L L  G A M E S"')
pages=('fav' 'gun' 'all')
page="${pages[$index]}"

list_path="$SCRIPT_DIR/.lists/.list_${page}"
total_files=$(( $(cat "$list_path" | wc -l) ))

timers=( \
  "$(( title_timeout * 10 ))" \
  "$(( art_timeout   * 10 ))" \
  "$(( screen_sleep  * 10 ))" \
  "$(( system_sleep  * 10 ))" \
)

files=()
input=''

# __________________________________________________________________________________________________________________________________________

Main() {
  echo -e "VFD 3  GAMES MENU v1.0" > /tmp/serial.fifo

  [[ $splashscreen -gt 0 ]] && showSplash 5

  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 1 ]]; then
      count=0
      navigate "$input"
    else
      count=$(( count + 1 ));

      if [[ $count -gt ${timers[$idle_state]} ]]; then
        [[ $idle_state -eq 0 ]] && [[ $init -eq 0 ]] && showTitle #{ showTitle; (( idle_state++ )); }
        [[ $idle_state -eq 1 ]] && [[ $auto_images -gt 0 ]] && showArtwork #{ showArtwork; (( idle_state++ )); }
        [[ $idle_state -eq 2 ]] && [[ $screensaver -gt 0 ]] && [[ $powerState -eq 1 ]] && screenState 0; #{ screenState 0; (( idle_state++ )); }
        [[ $idle_state -eq 3 ]] && [[ $asleep -eq 0 ]] && screenState 'sleep'
        [[ $idle_state -lt 3 ]] && idle_state=$(( idle_state + 1 ))
      fi
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1; [[ $? -gt 127 ]] && return

    case "$Event1" in
      [[:graph:]])      Event="$Event1" ;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  #screenState 1

  if [[ powerState -eq 0 ]]; then
    screenState 1; drawScreen 1
  else
    init=0
    case "${1}" in
      'UP')
  	  active=$(( active - 1 )); idle_state=0
          drawScreen 1
	  ;;
      'DOWN')
	  active=$(( active + 1 )); idle_state=0
          drawScreen 1
	  ;;
      'LEFT')
	  [[ $index -gt 0 ]] && index=$(( index - 1 ))
           setPage
	  ;;
      'RIGHT')
	  [[ $index -lt $(( ${#pages[@]} - 1 )) ]] && index=$(( index + 1 ))
           setPage
	  ;;
      'ENTER')
          launchGame
          init=1; idle_state=0
          drawScreen 1
	  ;;
      'SPACE')
          [[ $page == fav ]] && slideshow || showImage
	  ;;
      'ESC')
          echo -e "VFD 3  G O O D B Y E !" > /tmp/serial.fifo
          clear && exit 0
    	  ;;
    esac
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

launchGame() {
  path=$(getEntry)

  if [ -f "$path" ]; then
    system=$(echo "$path" | awk -F/ '{print $(NF-1)}')

    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" mode game "${path}" "$0" && sleep 0.5
    sudo -u pi bash -c  "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} $system dummy"
    #sudo -- bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} $system dummy"
    #python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py "${path}" "$system" dummy
    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" mode menu '' "$0"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  list=()
  while read line; do
    list+=("$(echo $line | cut -d\' -f2)")
  done< <(cat "$list_path" | sed -n ''"$(( offset + 1 ))"','"$(( offset + maxItems ))"'p')
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  [[ $(( active + offset )) -gt $total_files ]] && active=$(( active - 1 ))

  if [[ $active -gt $(( ${#list[@]} - 1 )) ]]; then
    if [[ $(( offset + maxItems )) -lt $total_files ]]; then
      offset=$(( offset + maxItems )); active=0; makeList
    fi
  fi
  if [[ $active -lt 0 ]]; then
    if [[ $offset -gt 0 ]]; then
        offset=$(( offset - maxItems )); active=$(( maxItems - 1 )); makeList
    else
      active=0
    fi
  fi
  [[ $# -gt 0 ]] && [[ $1 -gt 0 ]] && clear
  [[ $init -eq 1 ]] && sleep 0.5

  for (( i=0; i<${#list[@]}; i++ )) ; do
    [[ $i == $active ]] && marked=1 || marked=0
    printer "${list[$i]}" $marked
    #[[ $init -eq 1 ]] && { [[ $i -gt 3 ]] && sleep 0.1 || sleep 0.2; }
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  active=0; offset=0; init=1

  page="${pages[$index]}"
  list_path="$SCRIPT_DIR/.lists/.list_${page}"
  total_files=$(( $(cat "$list_path" | wc -l) ))

  [[ $first_boot -gt 0 ]] && first_boot=0 || echo -e "VFD 0 ${page_titles[$index]}" > /tmp/serial.fifo

  makeList
  drawScreen 1
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

getEntry() {
  entry=$(( ( offset + active ) + 1 ))
  str=$(sed -n ''"$entry"'p' "$list_path" | grep -o '[^ ]*$' | cut -d\' -f2)
  if   [[ "${1}" == name   ]]; then
    echo "$str" | grep -o '[^/]*$' | cut -d. -f1
  elif [[ "${1}" == system ]]; then
    echo "$str" | awk -F/ '{print $(NF-1)}'
  else
    echo "$str"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return

  txt="${1}"; mark="${2:-0}"; pad=''
  str="${C}${txt}"

  if [[ $center -gt 0 ]]; then
    strlen=${#str}; [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 )); strlen=$(( strlen / 2 ))
    length=$(( width / 2 )); length=$(( length - strlen )); printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";  str+="${NC}"

  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideTimeout() {
  [ $# -gt 0 ] && timeout=$1 || timeout=$screen_sleep; timedout=0

  while [[ $(pgrep -c fim) -lt 1 ]]; do :; done
  while [[ $(pgrep -c fim) -gt 0 ]]; do
    last=$(date +%s%N | tail -c 16 | head -c 6 | tail -c 3)
    sudo timeout $timeout \
    sudo bash -c 'while read c; do break; done< <( sudo thd --socket /run/thd.socket --dump /dev/input/event*)'
    this=$(date +%s%N | tail -c 16 | head -c 6 | tail -c 3); elapsed=$(( this - last ))
    [[ $elapsed -ge $timeout ]] && { timedout=1; sudo killall -15 fim; break; }
  done
  while [[ $(pgrep -c fim) -gt 0 ]]; do :; done; sleep 2
  [[ $timedout -gt 0 ]] && { sleep 2; screenState 0; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideTimeout_new() {
  [ $# -gt 0 ] && timeout=$1 || timeout=$screen_sleep; timedout=0

  while [[ $(pgrep -c fim) -lt 1 ]]; do :; done
  while [[ $(pgrep -c fim) -gt 0 ]]; do
    last=$(date +%s%N | tail -c 16 | head -c 6 | tail -c 3)
    sudo timeout $timeout \
    sudo bash -c 'while read c; do break; done< <( sudo thd --socket /run/thd.socket --dump /dev/input/event*)'
    this=$(date +%s%N | tail -c 16 | head -c 6 | tail -c 3); elapsed=$(( this - last ))
    #[[ $elapsed -ge $timeout ]] && { timedout=1; printf '\033' > /tmp/vkbdd.fifo; sudo killall -15 fim; break; }
    [[ $elapsed -ge $timeout ]] && { timedout=1; sudo killall -15 fim; break; }
  done
  while [[ $(pgrep -c fim) -gt 0 ]]; do :; done; sleep 2
  [[ $timedout -gt 0 ]] && { sleep 2; screenState 0; sleep 0.5; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideTimeout_old() {
  [ $# -gt 0 ] && timeout=$1 || timeout=$screen_sleep; timedout=0

  while [[ $(pgrep -c fim) -lt 1 ]]; do :; done
  while [[ $(pgrep -c fim) -gt 0 ]]; do
    last=$(date +%s%N | tail -c 13 | head -c 6)
    sudo timeout $timeout \
    sudo bash -c 'while read c; do break; done< <( sudo thd --socket /run/thd.socket --dump /dev/input/event*)'
    this=$(date +%s%N | tail -c 13 | head -c 6); last=$(( last / 1000 )); this=$(( this / 1000 )); elapsed=$(( this - last ))
    [[ $elapsed -ge $timeout ]] && { timedout=1; sudo killall -15 fim; break; }
  done
  while [[ $(pgrep -c fim) -gt 0 ]]; do :; done; sleep 2
  [[ $timedout -gt 0 ]] && { screenState 0; sleep 0.5; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  entry=$(( ( offset + active ) + 1 ))
  clear && sleep 0.5
  slideTimeout "$screen_sleep" &
  sudo bash "$SCRIPT_DIR/SLIDE.sh" "$entry" > "$SCRIPT_DIR/slideshow.log"

  line_count=$(cat "$SCRIPT_DIR/slideshow.log" | wc -l )
  for ((n=$line_count; n>0; n-- )); do
    val=$(sed -n ''"$n"'p' "$SCRIPT_DIR/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { active=$val; active=$(( active - 1 )); break; }
  done

  selected_game=$(getEntry 'name')
  [[ $(sed -n '$p' "$SCRIPT_DIR/slideshow.log") =~ "$selected_game" ]] && { \
    launchGame; init=1; idle_state=0; drawScreen 1; \
  }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
showTitle() {
  entry=$(( ( offset + active ) + 1 ))
  line=$(sed -n ''"$entry"'p' "$list_path" | awk '{$1=$1;print}')

  title=$(echo -n "$line" | cut -d\' -f2)
  date=$(echo -n "$line" | cut -d\' -f4)
  pub=$(echo -n "$line" | cut -d\' -f6)
  serial_str="$title ($date) [$pub]"

  echo -e "VFD 1 $serial_str" > /tmp/serial.fifo
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showSplash() {
  sudo fbi -a -T 1 -d /dev/fb0 -t $1 --once --noverbose "$HOMEDIR/downloads/artwork/splash1.jpg" #>/dev/null 2>&1 &
  sleep $(( $1 - 1 )) && clear
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showArtwork() {
  name=$(getEntry 'name'); system=$(getEntry 'system')
  file=$(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null)

  #[ -f "$file" ] && fim -N -T 1 -d /dev/fb0 -N --quiet --execute-script "$SCRIPT_DIR/fim_imgview.txt" "$file"
  if [ -f "$file" ]; then
    slideTimeout "$screen_sleep" &
    fim -N -T 1 -d /dev/fb0 -N --quiet --execute-script "$SCRIPT_DIR/fim_imgview.txt" "$file"
  fi

}

showImage() {
  name=$(getEntry 'name'); system=$(getEntry 'system')
  file=$(find "$art_path/${system}/${name}/" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null)

  [ -f "$file" ] && { sudo fbi -a -T 1 -d /dev/fb0 -t 3 --once --noverbose "$file"; sleep 3; }  #>/dev/null 2>&1 &
  init=1; idle_state=0; drawScreen
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

screenState() {
  if [[ $screensaver -gt 0 ]]; then
    if [[ $1 == sleep ]]; then
      sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" mode sleep
      asleep=1; powerState=0
    else
      [[ $1 -eq 0 ]] && { sudo -- bash -c "setterm --blank force --term linux </dev/tty1"; powerState=$1; drawScreen; }
      [[ $1 -eq 1 ]] && { sudo -- bash -c "setterm --blank poke --term linux </dev/tty1";  powerState=$1; }

      #[[ $1 -eq 0 ]] && [[ $powerState -eq 1 ]] && { sudo -- bash -c "setterm --blank force --term linux </dev/tty1"; powerState=$1; drawScreen; } #{ closeImage && sudo setterm --blank force --term linux; }
      #[[ $1 -eq 1 ]] && [[ $powerState -eq 0 ]] && { sudo -- bash -c "setterm --blank poke --term linux </dev/tty1";  powerState=$1; } #{ sudo setterm --blank poke  --term linux; }
    fi
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return

  txt="${1}"; mark="${2:-0}"; pad=''
  str="${C}${txt}"

  if [[ $center -gt 0 ]]; then
    strlen=${#str}; [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 )); strlen=$(( strlen / 2 ))
    length=$(( width / 2 )); length=$(( length - strlen )); printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";  str+="${NC}"

  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  if [[ $hide_term -gt 0 ]]; then
    export PS1="$PS1_stored"
    sudo -- bash -c "setterm --cursor on --term linux </dev/tty1"
  fi
  echo -e "VFD 3  G O O D B Y E " > /tmp/serial.fifo
  #setterm --cursor on
  #sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" mode term '' "$0"
  exit
}

# ---------------------------------------------------------------------------------------------------------------



#[ ! -f "$SCRIPT_DIR/.lists/.list_all" ] && { echo "Creating list.."; sudo bash "$SCRIPT_DIR/.create_list.sh"; }

if [[ $hide_term -gt 0 ]]; then
  PS1_stored="$PS1"; export PS1='\[$(tput sgr0)\]\[$(tput sgr0)\] '
  sudo -- bash -c "setterm --cursor off --term linux </dev/tty1" #setterm --cursor off
fi

sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" mode menu '' "$0"
trap 'exitFunc' EXIT SIGINT INT

Main

exit



# __________________________________________________________________________________________________________________________________________

