#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# --------------------------------------------------------------------------------------------------------------

offset="${1:-1}"
list=($(cat "$SCRIPT_DIR/.lists/.list_fav" | grep -o '[^/]*$' | cut -d\' -f1 | cut -d. -f1));

fim -N -T 1 -d /dev/fb0 \
   -C $offset \
   --quiet \
   --execute-script "$SCRIPT_DIR/fim_slideshow.txt" \
   --read-from-stdin< <( for l in "${list[@]}"; do find "$SCRIPT_DIR/.assets/mame-libretro/$l" -regextype posix-extended -regex '.*\.(jpg|png)' -print -quit 2>/dev/null; done )
   #--write-scriptout "$SCRIPT_DIR/stdout.log" \
   #--write-scriptout /dev/stdout \
exit



# __________________________________________________________________________________________________________________________________________

