#!/bin/bash


NEWT_COLORS_1='
    root=green,black
    border=green,black
    window=black,black
    shadow=black,grey
    title=green,black
    button=black,green
    actbutton=green,black
    compactbutton=green,black
    checkbox=green,black
    actcheckbox=black,green
    entry=black,green # textfelt?
    disentry=green,black
    label=green,black
    listbox=green,black
    actlistbox=brightgreen,black
    sellistbox=black,green
    actsellistbox=black,green
    textbox=green,black
    acttextbox=green,black
    emptyscale,green
    fullscale=,green
    helpline=green,black
    roottext=black,green
'
export NEWT_COLORS=$NEWT_COLORS_1

  SCRIPT=$(readlink -f $0)
  SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
  HOMEDIR=$(getent passwd pi | cut -d: -f6)

  cafca_path='/home/pi/CAFCA'
  gamelist='/home/pi/.emulationstation/collections/custom-arkade.cfg'
  data_file='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
  rom_dir='/home/pi/RetroPie/roms/mame-libretro'
  list_path="$SCRIPT_DIR/.list"

# ----------------------------------------------------------------------

Main() {
  declare -a entries; declare -a paths; count=0
  printf '' | sudo tee "$list_path" &>/dev/null

  while read line; do
    name=$(echo "$line" | awk -F'\\/' '{split($NF, array, "."); print array[1]}')
    title=$(grep -Ew -A1 "<path>./$name.zip" "$data_file" | awk 'NR==2 {$1=$1;print}' | awk -F'\\<|\\>' '{print $3}')
    echo "$title $line" | sudo tee -a "$list_path" &>/dev/null
  done< <(cat "$gamelist") && cat "$list_path" | sort -k 1,1 | sudo tee "$list_path" &>/dev/null

  while read line; do
    entries+=("$count")
    entries+=("$(echo $line | rev | cut -d' ' -f 2- | rev)")
    paths+=("$(echo $line | grep -o '[^ ]*$')")
    (( count++ ))
  done< <(cat "$list_path")

  sudo -u pi bash -c "bash $HOMEDIR/ADMIN/CMD/joy2key/joy2key.sh START"

  while :; do
    choice=$( whiptail --title "  CAFCA MENU:  " --menu "Select entry: " 20 56 12 "${entries[@]}" 3>&2 2>&1 1>&3 )
    [ $? -gt 0 ] && exit
    #echo "choice: $choice - ${paths[$choice]}" && sleep 2
    sudo -u pi bash -c "bash $HOMEDIR/ADMIN/CMD/joy2key/joy2key.sh STOP"
    python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py "${paths[$choice]}" mame-libretro dummy
    sudo -u pi bash -c "bash $HOMEDIR/ADMIN/CMD/joy2key/joy2key.sh START"
  done
  exit
}



 ##################################################################################


 game_start() {
   sudo sed -i '/UI/ s/UI[=].*$/UI=3/' "$HOMEDIR/ADMIN/.sys/.states"
   sudo th-cmd --socket /run/thd.socket --remove /dev/input/by-id/usb-SHANWAN_Skyuan_F16-event-joystick --tag joy
   sudo th-cmd --socket /run/thd.socket --mode ra
   sudo sed -i '/THD_MODE/ s/THD_MODE[=].*$/THD_MODE=RA/' "$HOMEDIR/ADMIN/.sys/.states"


   sudo cp -r "$HOMEDIR/CAFCA/data/.states.default" "$HOMEDIR/CAFCA/data/.states"
   sudo sed -i '/GAME_LOADED/ s/GAME_LOADED[=].*$/GAME_LOADED=1/' "$HOMEDIR/CAFCA/data/.states"
   sudo sed -i "/ACTIVE_GAME/ s/ACTIVE_GAME[=].*$/ACTIVE_GAME=\x27${system}\/${game}\x27/" "$HOMEDIR/CAFCA/data/.states"
 }


  startJoy() {
    #JOY_NAME='SHANWAN'; DEV=$(ls -l /dev/input/by-id | grep "$JOY_NAME" | grep js | awk -F'../' '{print "/dev/input/"$2}')
    DEV=$(grep -m1 'DEV joystick' /home/pi/ADMIN/.sys/.settings | cut -d\' -f2)
    PROCS=$(ps -ef | grep -v grep | grep -wc joy2key.py)

    [[ $PROCS -lt 1 ]] && python3 "/home/pi/ADMIN/CMD/joy2key/joy2key.py" "$DEV" kcuf1 kcub1 kcud1 kcuu1 0x0a 0x20 &
  }

  exitFunc() {
    kill -9 $(ps -ef | grep -v grep | grep -i joy2key.py | awk '{print $2}') &>/dev/null
  }

  trap 'exitFunc' EXIT SIGINT INT

  Main

