#!/bin/bash

file="/home/pi/menu/_bootpath"
bootMenu=$(cat "$file")

echo "Set Boot Menu:"
echo "Current: $bootMenu"

# customize with your own.
options=("ADMIN MENU" "ALL GAMES" "BEST OF" "80S" "EMULATIONSTATION" "EXIT")

menu() {
    echo "Avaliable options:"
    for i in ${!options[@]}; do 
        printf "%3d%s) %s\n" $((i+1)) "${choices[i]:- }" "${options[i]}"
    done
    if [[ "$msg" ]]; then echo "$msg"; fi
}

prompt="Check an option (again to uncheck, ENTER when done): "
while menu && read -rp "$prompt" num && [[ "$num" ]]; do
    [[ "$num" != *[![:digit:]]* ]] &&
    (( num > 0 && num <= ${#options[@]} )) ||
    { msg="Invalid option: $num"; continue; }
    ((num--)); msg="${options[num]} was ${choices[num]:+un}checked"
    [[ "${choices[num]}" ]] && choices[num]="" || choices[num]="+"
done

#printf "You selected"; msg=" nothing"
#for i in ${!options[@]}; do 
#    [[ "${choices[i]}" ]] && { printf " %s" "${options[i]}"; msg=""; }
#done

echo "$msg"

if [[ "${!choices[@]}" -eq 0 ]];
then
echo "Wrote file to ~/menu/_bootpath:";
printf "\x2Fhome\x2Fpi\x2Fmenu\x2Fadmin\x2Fadmin-menu.sh" | sudo tee /home/pi/menu/_bootpath;
elif [[ "${!choices[@]}" -eq 1 ]];
then
echo "Wrote file to ~/menu/_boot:";
printf "\x2Fhome\x2Fpi\x2Fmenu\x2Fgames\x2F_menu-all.sh" | sudo tee /home/pi/menu/_bootpath;
elif [[ "${!choices[@]}" -eq 2 ]];
then
echo "Wrote file to ~/menu/_boot:";
printf "\x2Fhome\x2Fpi\x2Fmenu\x2Fgames\x2F_menu-bestof.sh"" | sudo tee /home/pi/menu/_bootpath;
elif [[ "${!choices[@]}" -eq 3 ]];
then
echo "Wrote file to ~/menu/_boot:";
printf "4" | sudo tee /home/pi/menu/_bootpath;
elif [[ "${!choices[@]}" -eq 3 ]];
then
echo "Wrote file to ~/menu/_boot:";
printf "emulationstation" | sudo tee /home/pi/menu/_bootpath;
elif [[ "${!choices[@]}" -eq 3 ]];
then
echo "EXIT";
#printf "6" | sudo tee /home/pi/menu/_bootpath;
fi

#echo "Index: ${!choices[@]}"
