#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

cafca_path='/home/pi/CAFCA'
gamelist='/home/pi/.emulationstation/collections/custom-arkade.cfg'
data_file='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
rom_dir='/home/pi/RetroPie/roms/mame-libretro'
list_path="$SCRIPT_DIR/.list_all"

C="$(echo -e "\033[32m")"; NC="$(echo -e "\033[0m")"; MARK="$(echo -e "\e[7m")"; UNMARK="$(echo -e "\e[0m")"
PS1_stored="$PS1"; export PS1='\[$(tput sgr0)\]\[$(tput sgr0)\] '

exitFunc() {
  export PS1="$PS1_stored" && exit
}

trap 'exitFunc' EXIT SIGINT INT

exec 2> "$SCRIPT_DIR/errors.log"

# ------------------------------------------------------------------------------------------------

# options:

title_timeout=2000
screen_sleep=60000
system_sleep=$(grep -w -m1 timeout "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2); system_sleep=$(( system_sleep * 1000 ))

center=1
animate=1
drawDelay=0.125

# ------------------------------------------------------------------------------------------------

# globals:

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 )); height=$(echo "$(tput lines)")
maxItems=$(( height - 1 ))

index=0; offset=0; count=0; idle_state=0; init=1; first_boot=1; active=1

page_titles=( '  T O P  L I S T' ' L I G H T G U N' 'A L L  G A M E S"')
pages=('fav' 'gun' 'all')

page="${pages[$index]}"
list_path="$SCRIPT_DIR/.list_${page}"

total_files=$(( $(cat "$list_path" | wc -l) - 1 ))

# ------------------------------------------------------------------------------------------------


Main() {
  showSplash 5 && clear
  setPage

  while :; do
    rc=255; idle_state=0; count=0

    while [[ $rc -gt 127 ]]; do
      read -sN1 -t 0.001 input; rc=$?; count=$(( count + 1 ))
      [[ $idle_state -eq 0 ]] && [[ $count -gt "$title_timeout" ]] && { (( idle_state++ )); showTitle; }
      [[ $idle_state -eq 1 ]] && [[ $count -gt "$screen_sleep"  ]] && { (( idle_state++ )); screenState 0; }
      [[ $idle_state -eq 2 ]] && [[ $count -gt "$system_sleep"  ]] && { (( idle_state++ )); screenState 'sleep'; }
    done
    screenState 1

    case "$input" in
      $'\x1B')
        read -sN1 -t0.1 val
        if [ "$val" == "[" ]; then
          read -sN1 -t0.1 key
          case "$key" in
            A) navigate "UP" ;;
            B) navigate "DOWN" ;;
            C) navigate "RIGHT" ;;
            D) navigate "LEFT" ;;
          esac
        fi
        ;;
      $'\x0a'|'\x0d')
    	  navigate "ENTER"
	  ;;
      $'\x20'|'\x1b')
          clear
          exit 0
	  ;;
      *)  ;;
    esac
  done
}

navigate() {
  init=0; sudo pkill fbi

  case "${1}" in
    'UP')
	active=$(( active - 1 ))
        drawScreen
	;;
    'DOWN')
	active=$(( active + 1 ))
        drawScreen
	;;
    'LEFT')
	[[ $index -gt 0 ]] && index=$(( index - 1 ))
         setPage
	;;
    'RIGHT')
	[[ $index -lt $(( ${#pages[@]} - 1 )) ]] && index=$(( index + 1 ))
         setPage
	;;
    'ENTER')
        entry=$(( ( offset + active ) + 1 ))
        path=$(sed -n ''"$entry"'p' "$list_path" | grep -o '[^ ]*$' | cut -d\' -f2)
        launchGame "$path"; init=1
        drawScreen
	;;
  esac
}

launchGame() {
  [ $# -gt 0 ] && path="${1}"
  if [ -f "$path" ]; then
    system=$(echo "$path" | awk -F/ '{print $(NF-1)}')

    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" game "${path}" "$0"
    python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py "${path}" "$system" dummy
    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" menu '' "$0"
  fi
}

makeList() {
  list=()
  while read line; do
    list+=("$(echo $line | cut -d\' -f2)")
  done< <(cat "$list_path" | sed -n ''"$(( offset + 1 ))"','"$(( offset + maxItems ))"'p')
}

drawScreen() {
  [[ $(( active + offset )) -gt $total_files ]] && active=$(( active - 1 ))

  if [[ $active -gt $(( ${#list[@]} - 1 )) ]]; then
    if [[ $(( offset + maxItems )) -lt $total_files ]]; then
      offset=$(( offset + maxItems )); active=0; makeList
    fi
  fi
  if [[ $active -lt 0 ]]; then
    if [[ $offset -gt 0 ]]; then
        offset=$(( offset - maxItems )); active=$(( maxItems - 1 )); makeList
    else
      active=0
    fi
  fi

  # ---------------------------------------------------------------

  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do
    [[ $i == $active ]] && marked=1 || marked=0
    printer "${list[$i]}" $marked
    [[ $init -eq 1 ]] && sleep $drawDelay
  done
}

setPage() {
  active=0; offset=0; init=1

  page="${pages[$index]}"
  list_path="$SCRIPT_DIR/.list_${page}"
  total_files=$(( $(cat "$list_path" | wc -l) - 1 ))

  [[ $first_boot -gt 0 ]] && first_boot=0 || echo -e "VFD 0 ${page_titles[$index]}" > /tmp/serial.fifo
  #echo -e "VFD 0 ${page_titles[$index]}" > /tmp/serial.fifo

  makeList && clear && sleep 1
  drawScreen
}

showSplash() {
  sudo fbi -T 1 -a -d /dev/fb0 --noverbose --once "$HOMEDIR/downloads/artwork/splash1.jpg" &>/dev/null &
  sleep "$1" && sudo killall fbi && clear
  #sleep "$1" &&  screenState 0 && sudo killall fbi && clear && screenState 1
}

showArtwork() {
  sudo fbi -T 1 --once --noverbose -d /dev/fb0 "$HOMEDIR/downloads/artwork/asteroids.png" &>/dev/null & #sleep 2 && sudo pkill fbi &>/dev/null
}

showTitle() {
  entry=$(( ( offset + active ) + 1 ))
  line=$(sed -n ''"$entry"'p' "$list_path" | awk '{$1=$1;print}')

  title=$(echo -n "$line" | cut -d\' -f2)
  date=$(echo -n "$line" | cut -d\' -f4)
  pub=$(echo -n "$line" | cut -d\' -f6)
  serial_str="$title ($date) [$pub]"

  #[[ $init -eq 0 ]] && { \
  #  echo -e "VFD 1 $serial_str" > /tmp/serial.fifo; \
  #  showArtwork; \
  #}

  [[ $init -eq 0 ]] && echo -e "VFD 1 $serial_str" > /tmp/serial.fifo
}

screenState() {
  if [[ $1 == sleep ]]; then
    sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" sleep &
  else
    [[ $1 -eq 0 ]] && sudo setterm --blank force --term linux #</dev/tty1
    [[ $1 -eq 1 ]] && sudo setterm --blank poke  --term linux #</dev/tty1
  fi
}

printer() {
  [[ $# -lt 1 ]] && return

  txt="${1}"; mark="${2:-0}"; pad=''
  str="${C}${txt}"

  if [[ $center -gt 0 ]]; then
    strlen=${#str}; [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 )); strlen=$(( strlen / 2 ))
    length=$(( width / 2 )); length=$(( length - strlen )); printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";  str+="${NC}"; 

  echo -e "${str}"
}

# ------------------------------------------------------------------------------------------------

#[ ! -f "$SCRIPT_DIR/.list_all" ] && { echo "Creating list.."; sudo bash "$SCRIPT_DIR/.create_list.sh"; }
sudo bash "$HOMEDIR/ADMIN/CMD/STATE/STATE.sh" menu '' "$0"


Main

exit

# ------------------------------------------------------------------------------------------------

