#!/bin/bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

cafca_path='/home/pi/CAFCA'
gamelist='/home/pi/.emulationstation/collections/custom-arkade.cfg'
data_file='/home/pi/.emulationstation/gamelists/mame-libretro/gamelist.xml'
rom_dir='/home/pi/RetroPie/roms/mame-libretro'
list_path="$SCRIPT_DIR/.list"

C="$(echo -e "\033[32m")"; NC="$(echo -e "\033[0m")"; MARK="$(echo -e "\e[7m")"; UNMARK="$(echo -e "\e[0m")"
PS1_stored="$PS1"; export PS1='\[$(tput sgr0)\]\[$(tput sgr0)\] '

exitFunc() {
  export PS1="$PS1_stored" && exit
}

trap 'exitFunc' EXIT SIGINT INT


# ------------------------------------------------------------------------------------------------

clear
width=$(echo "$(tput cols)")
height=$(echo "$(tput lines)")
#echo "width: $width, height: $height"
#sleep 5

clear

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"
  str="${C}"
  [[ $mark -gt 0 ]] && str+="${MARK}" #str="${str}${MARK}"
  str+="${txt}" #str="${str}${txt}"
  [[ $mark -gt 0 ]] && str+="${UNMARK}" #str="${str}${UNMARK}"
  str+="${NC}" #str="${str}${NC}"
  echo -e "${str}"
}

printer "UNMARKED TEXT"
printer "MARKED TEXT" 1

while :; do
  read -sN1 input

  case "$input" in
    $'\x1B')
      read -N1 -t0.1 val
      if [ "$val" == "[" ]; then
        read -N1 -t0.1 key
        case "$key" in
          A) printer "UP" ;;
          B) printer "DOWN" ;;
          C) printer "RIGHT" ;;
          D) printer "LEFT" ;;
        esac
      fi
      ;;
    $'\x0a'|'\x0d')
    	printer "ENTER"
	;;
    $'\x20'|'\x1b')
        printer "SPACE" && sleep 1
        clear
        exit 0
	;;
    *)  ;;
  esac
done

exit



# ------------------------------------------------------------------------------------------------

#T="${1:-1}"
#read -sN 1 -t "$T" char
#[ $? -gt 127 ] && { echo "timeout!"; exit 1; }
