#!/bin/bash


function print_menu() {
  local function_arguments=($@)
  local selected_item="$1"
  local menu_items=(${function_arguments[@]:1})
  local menu_size="${#menu_items[@]}"

  printf "   \033[32m"$(( page + 1 ))"/"$pages"             CFG:\033[0m\n\n"

  for (( i = 0; i < $menu_size; ++i ))
    do
      if [ "$i" = "$selected_item" ]; then
        #echo "-> ${menu_items[i]}"
        printf "\033[32m-> "${menu_items[i]}"\033[0m"
      else
        #echo "   ${menu_items[i]}"
        printf "   \033[32m"${menu_items[i]}"\033[0m"
      fi

      if [ -f "$rom_dir/${menu_items[i]}.cfg" ]; then
         title_len=$(( $(echo "${menu_items[i]}" | wc -m) -1 ))

         for (( c = $title_len; c < 16; c++ )); do
           printf " "
         done
         printf "X"
      fi
      #[ -f "$rom_dir/${menu_items[i]}.cfg" ] && printf "\033[32m\t\t\tX\033[0m"

      printf "\n"
    done
}

function run_menu() {
  local function_arguments=($@)

  local selected_item="$1"
  local menu_items=(${function_arguments[@]:1})
  local menu_size="${#menu_items[@]}"
  local menu_limit=$((menu_size - 1))
  sleep 0.1
  clear

  print_menu "$selected_item" "${menu_items[@]}"

  while read -rsn1 input; do
    case "$input"
    in
      $'\033')
        exit
        ;;

      $'\x1B')  # ESC ASCII code (https://dirask.com/posts/ASCII-Table-pJ3Y0j)
        read -rsn1 -t 0.1 input
        if [ "$input" = "[" ]; then
            read -rsn1 -t 0.1 input
            case "$input"
            in
              A)  # Up Arrow
                echo "UP"
                if [ "$selected_item" -ge 1 ]; then
                  selected_item=$((selected_item - 1))
                  clear
                  print_menu "$selected_item" "${menu_items[@]}"
                fi
                ;;
              B)  # Down Arrow
                echo "DOWN"
	        if [ "$selected_item" -lt "$menu_limit" ]; then
                  selected_item=$((selected_item + 1))
                  clear
                  print_menu "$selected_item" "${menu_items[@]}"
                fi
                ;;
              C)  # Right Arrow
                echo "RIGHT"
                if [ "${#menu_items[@]}" -ge "$page_size" ]; then
                  lines_read=$(( lines_read + page_size ))
                  page=$(( page + 1 ))
                  setPage
                fi
                clear
                print_menu "$selected_item" "${menu_items[@]}"
                ;;
             D)  # Left Arrow
                echo "LEFT"
               if [ "$lines_read" -gt 0 ]; then
                 lines_read=$(( lines_read - page_size ))
                 page=$(( page - 1 ))
                 setPage
               fi
               clear
               print_menu "$selected_item" "${menu_items[@]}"

              ;;
          esac
        fi

        read -rsn5 -t 0.1  # flushing stdin
        ;;

      "") # Enter key
        return "$selected_item"
        ;;
    esac
  done
}

function setPage() {
  limit=$(( titles - lines_read ))
  menu_items=( "$(cat $gamelist | tail -n $limit | head -n $page_size)" )
  selected_item=0
}


# MAIN:

rom_dir=/home/pi/RetroPie/roms/mame-libretro
#gamelist=/home/pi/CAFCA/.gamelist
#gamelist='/home/pi/ADMIN/.sys/titles/arkade.titles'
gamelist='/home/pi/.emulationstation/collections/custom-arkade.cfg'
#ls -la $rom_dir | grep ".zip" | awk '{print $9}' | cut -d. -f1 | sudo tee $gamelist &> /dev/null

titles=$(cat $gamelist | wc -l)
page_size=$(( $(tput lines) - 3 ))
pages=$((titles / page_size))
[[ $(( $titles % $page_size )) -gt 0 ]] && pages=$(( pages + 1 ))


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

#sudo bash /home/pi/CAFCA/setup/gamelist_creator.sh &>/dev/null

while :; do
  page=0
  lines_read=0
  selected_item=0

  menu_items=()

  clear

  setPage
  #sleep 10
  #exit

  run_menu "$selected_item" "${menu_items[@]}"
  menu_result="$?"
  entry=$(( ((page_size * page) + menu_result) + 1 ))

  name=$(sed -n "$entry"p $gamelist)

  clear && echo

  printf "\033[32mentry["$entry"]: "$name && sleep 1

  #[ -f "$rom_dir/$name.cfg" ] && printf "\033[32m - found .cfg!\033[0m\n" || printf "\033[32m - no .cfg for game..\033[0m\n"

  sleep 1
  #sudo nano "$rom_dir/$name.cfg"
  clear

done

exit








