#!/bin/bash

PID=$$
HOMEDIR='/home/pi'
list_path="$HOMEDIR/ADMIN/MENU/.assets/list"

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# VARIABLES
list=(); indexes=(); timers=();
pageIndex=0; total_files=0; offset=0; active=0; prev=0; timer=0; idle_state=0

pages=($(awk -F'\[|\]' '{print $2}' "$list_path" | sed 's/[ ]/\n/g;' | sed ' /^$/d' | sort -u)); pages+=("ALL")
page="${pages[$pageIndex]}"

width=$(echo "$(tput cols)");  [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 2 ))

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#OPTIONS
colors=1
center=1
t_title=2
t_saver=30
t_sleep=60

#________________________________________________________________________________________________________________________________________________


Main() {
  sendSerial "VFD 6  W E L C O M E "
  setPage
  while true; do
    input=$(readInput)
    if [[ ${#input} -gt 1 ]]; then
      navigate "$input"; idle_state=0; elapsed 0
    else
      if [[ $(elapsed) -ge ${timers[$idle_state]} ]]; then
	case $idle_state in
	  0) showTitle ;; #sendSerial "VFD 0 time > timers[$idle_state] ( ${timers[$idle_state]} )" ;;
	  1) sendSerial "VFD 0 time > timers[$idle_state] ( ${timers[$idle_state]} )" ;;
	  2) ;;
	  *) ;;
	esac
        [[ $idle_state -lt ${#timers[@]} ]] && (( idle_state++ ));
      fi
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  states[COUNT]=0; states[INIT]=0; states[IDLE_STATE]=0

  case "${1}" in
    'UP')
	prev=$active
	[[ $(( active + offset )) -gt 0 ]] && { \
	  (( active-- )); drawScreen; \
        }
	;;
    'DOWN')
	prev=$active
	[[ $(( active + offset )) -lt $(( total_files - 1 )) ]] && { \
	  (( active++ )); drawScreen; \
	}
	;;
    'LEFT')
	(( pageIndex-- )); changePage
	;;
    'RIGHT')
	(( pageIndex++ )); changePage
	;;
    'ENTER')
	launchGame
	;;
    'SPACE')
	echo "SPACE" ;;
    'ESC')
	exit 0 ;;
  esac
}

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

drawScreen() {
  if [[ $active -lt 0 ]] && [[ $offset -gt 0 ]]; then
    offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ))
  elif [[ $active -ge ${#list[@]} ]]; then
    offset=$(( offset + maxPage )); makeList
  fi
  markLine
}

makeList() {
  list=(); active=0
  for (( i=$(( offset + active )); i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4)
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do printer "${list[$i]}" 0; done; echo ""
}

changePage() {
  [[ $pageIndex -lt 0 ]] && pageIndex=$(( ${#pages[@]} - 1 )) || { \
  [[ $pageIndex -ge ${#pages[@]} ]] && pageIndex=0; }

  page="${pages[$pageIndex]}"; setPage
}

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  total_files=${#indexes[@]}; offset=0

  sendSerial "VFD 1       $page"
  clear; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

launchGame() {
  entry=$(( offset + active ))
  idx=${indexes[$entry]}
  path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)

  if [ -f "$path" ]; then
    system=$(echo "$path" | awk -F/ '{print $(NF-1)}')
    game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)
    sudo sed -i "/ACTIVE_GAME/ s/ACTIVE_GAME[=].*$/ACTIVE_GAME=\x27${system}\/${game}\x27/" "$HOMEDIR/CAFCA/data/.states"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game

    sudo -u pi bash -c  "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} $system dummy"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu

    makeList; active=$prev
    drawScreen; sudo setterm --cursor off
  fi
}

showTitle() {
  entry=$(( offset + active ));
  idx=${indexes[$entry]}; #path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)
  title=$(awk -F'\x27' -v l="$idx" 'NR==l {print $4,"("$6")","["$8"]"}' "$list_path")
  sendSerial "VFD 1 $title" && sleep 2
}

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      [[:graph:]])      Event="$Event1" ;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"; pad=''; str=''

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"
  echo -e "${str}"
}

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

elapsed() {
  [ $# -gt 0 ] \
  && timer=$(echo $(( 10#$(date +%s) ))) \
  || echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

bgTimer() {
  timeout=$t_sleep

  while :; do
    start=$(echo $(( 10#$(date +%s | tail -c 4) )))
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(echo $(( 10#$(date +%s | tail -c 4) )))
    elapsed=$(echo $(( 10#$(( end - start )) )) )

    # if pgrep -c retroarch -lt 1:
    if [[ $elapsed -ge $timeout ]]; then
      sendSerial "ASLEEP 1"
      while read line; do break; done< <(thd --dump /dev/input/event*)
      sendSerial "ASLEEP 0"
    fi
  done
}

Init() {
  timers=( "$t_title" "$t_saver" "$t_sleep" )

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu

  stty -F /dev/tty1 -echo
  sudo setterm --cursor off
  trap 'exitFunc' EXIT SIGINT INT

  elapsed 0
  bgTimer $PID &
}

exitFunc() {
  #[[ $hide_term -gt 0 ]] && { export PS1="$PS1_stored"; }

  sendSerial "VFD 3  G O O D B Y E "

  stty -F /dev/tty1 sane
  sudo setterm --cursor on

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term

  sudo kill -9 $(jobs -p) && clear
  exit
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init
Main

exit
